/************************************************************************************************/
/* Stata User File for H155 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H155.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H155.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H155.DO                                               */
/* The program below will output the Stata dataset H155.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID12 25-26
  str    FAMIDYR 27-28
  str    CPSFAMID 29-30
  byte   FCSZ1231 31-32
  byte   FCRP1231 33-34
  str    RULETR31 35-36
  str    RULETR42 37-38
  str    RULETR53 39-40
  str    RULETR12 41-42
  byte   RUSIZE31 43-44
  byte   RUSIZE42 45-46
  byte   RUSIZE53 47-48
  byte   RUSIZE12 49-50
  byte   RUCLAS31 51-52
  byte   RUCLAS42 53-54
  byte   RUCLAS53 55-56
  byte   RUCLAS12 57-57
  byte   FAMSZE31 58-59
  byte   FAMSZE42 60-61
  byte   FAMSZE53 62-63
  byte   FAMSZE12 64-65
  byte   FMRS1231 66-67
  byte   FAMS1231 68-69
  byte   FAMSZEYR 70-71
  byte   FAMRFPYR 72-72
  byte   REGION31 73-74
  byte   REGION42 75-76
  byte   REGION53 77-78
  byte   REGION12 79-80
  byte   MSA31 81-82
  byte   MSA42 83-84
  byte   MSA53 85-86
  byte   MSA12 87-88
  int    REFPRS31 89-91
  int    REFPRS42 92-94
  int    REFPRS53 95-97
  int    REFPRS12 98-100
  byte   RESP31 101-101
  byte   RESP42 102-102
  byte   RESP53 103-103
  byte   RESP12 104-104
  byte   PROXY31 105-106
  byte   PROXY42 107-108
  byte   PROXY53 109-110
  byte   PROXY12 111-111
  byte   INTVLANG 112-113
  byte   BEGRFD31 114-115
  byte   BEGRFM31 116-117
  int    BEGRFY31 118-121
  byte   ENDRFD31 122-123
  byte   ENDRFM31 124-125
  int    ENDRFY31 126-129
  byte   BEGRFD42 130-131
  byte   BEGRFM42 132-133
  int    BEGRFY42 134-137
  byte   ENDRFD42 138-139
  byte   ENDRFM42 140-141
  int    ENDRFY42 142-145
  byte   BEGRFD53 146-147
  byte   BEGRFM53 148-149
  int    BEGRFY53 150-153
  byte   ENDRFD53 154-155
  byte   ENDRFM53 156-157
  int    ENDRFY53 158-161
  byte   ENDRFD12 162-163
  byte   ENDRFM12 164-165
  int    ENDRFY12 166-169
  byte   KEYNESS 170-170
  byte   INSCOP31 171-171
  byte   INSCOP42 172-172
  byte   INSCOP53 173-173
  byte   INSCOP12 174-174
  byte   INSC1231 175-175
  byte   INSCOPE 176-176
  byte   ELGRND31 177-177
  byte   ELGRND42 178-178
  byte   ELGRND53 179-179
  byte   ELGRND12 180-180
  byte   PSTATS31 181-182
  byte   PSTATS42 183-184
  byte   PSTATS53 185-186
  str    RURSLT31 187-188
  str    RURSLT42 189-190
  str    RURSLT53 191-192
  byte   AGE31X 193-194
  byte   AGE42X 195-196
  byte   AGE53X 197-198
  byte   AGE12X 199-200
  byte   AGELAST 201-202
  byte   DOBMM 203-204
  int    DOBYY 205-208
  byte   SEX 209-209
  byte   RACEVER 210-210
  byte   RACEV1X 211-211
  byte   RACEAX 212-212
  byte   RACEBX 213-213
  byte   RACEWX 214-214
  byte   RACETHX 215-215
  byte   HISPANX 216-216
  byte   HISPCAT 217-218
  byte   MARRY31X 219-220
  byte   MARRY42X 221-222
  byte   MARRY53X 223-224
  byte   MARRY12X 225-226
  int    SPOUID31 227-229
  int    SPOUID42 230-232
  int    SPOUID53 233-235
  int    SPOUID12 236-238
  byte   SPOUIN31 239-240
  byte   SPOUIN42 241-242
  byte   SPOUIN53 243-244
  byte   SPOUIN12 245-246
  byte   EDUCYR 247-248
  byte   EDUYRDEG 249-250
  byte   HIDEG 251-252
  byte   EDRECODE 253-254
  byte   FTSTU31X 255-256
  byte   FTSTU42X 257-258
  byte   FTSTU53X 259-260
  byte   FTSTU12X 261-262
  byte   ACTDTY31 263-264
  byte   ACTDTY42 265-266
  byte   ACTDTY53 267-268
  byte   HONRDC31 269-270
  byte   HONRDC42 271-272
  byte   HONRDC53 273-274
  byte   RFREL31X 275-276
  byte   RFREL42X 277-278
  byte   RFREL53X 279-280
  byte   RFREL12X 281-282
  int    MOPID31X 283-285
  int    MOPID42X 286-288
  int    MOPID53X 289-291
  int    DAPID31X 292-294
  int    DAPID42X 295-297
  int    DAPID53X 298-300
  byte   RTHLTH31 301-302
  byte   RTHLTH42 303-304
  byte   RTHLTH53 305-306
  byte   MNHLTH31 307-308
  byte   MNHLTH42 309-310
  byte   MNHLTH53 311-312
  byte   HIBPDX 313-314
  byte   HIBPAGED 315-316
  byte   BPMLDX 317-318
  byte   CHDDX 319-320
  byte   CHDAGED 321-322
  byte   ANGIDX 323-324
  byte   ANGIAGED 325-326
  byte   MIDX 327-328
  byte   MIAGED 329-330
  byte   OHRTDX 331-332
  byte   OHRTAGED 333-334
  byte   STRKDX 335-336
  byte   STRKAGED 337-338
  byte   EMPHDX 339-340
  byte   EMPHAGED 341-342
  byte   CHBRON31 343-344
  byte   CHBRON53 345-346
  byte   CHOLDX 347-348
  byte   CHOLAGED 349-350
  byte   CANCERDX 351-352
  byte   CABLADDR 353-354
  byte   BLDRAGED 355-356
  byte   BLDRREMS 357-358
  byte   CABRAIN 359-360
  byte   BRAIAGED 361-362
  byte   BRAIREMS 363-364
  byte   CABREAST 365-366
  byte   BRSTAGED 367-368
  byte   BRSTREMS 369-370
  byte   CACERVIX 371-372
  byte   CERVAGED 373-374
  byte   CERVREMS 375-376
  byte   CACOLON 377-378
  byte   COLOAGED 379-380
  byte   COLOREMS 381-382
  byte   CALEUKEM 383-384
  byte   LEUKAGED 385-386
  byte   LEUKREMS 387-388
  byte   CALUNG 389-390
  byte   LUNGAGED 391-392
  byte   LUNGREMS 393-394
  byte   CALYMPH 395-396
  byte   LYMPAGED 397-398
  byte   LYMPREMS 399-400
  byte   CAMELANO 401-402
  byte   MELAAGED 403-404
  byte   MELAREMS 405-406
  byte   CAOTHER 407-408
  byte   OTHRAGED 409-410
  byte   OTHRREMS 411-412
  byte   CAPROSTA 413-414
  byte   PRSTAGED 415-416
  byte   PRSTREMS 417-418
  byte   CASKINNM 419-420
  byte   SKNMAGED 421-422
  byte   SKNMREMS 423-424
  byte   CASKINDK 425-426
  byte   SKDKAGED 427-428
  byte   SKDKREMS 429-430
  byte   CATHROAT 431-432
  byte   THRTAGED 433-434
  byte   THRTREMS 435-436
  byte   CATHYROD 437-438
  byte   THYRAGED 439-440
  byte   THYRREMS 441-442
  byte   DIABDX 443-444
  byte   DIABAGED 445-446
  byte   JTPAIN31 447-448
  byte   JTPAIN53 449-450
  byte   ARTHDX 451-452
  byte   ARTHTYPE 453-454
  byte   ARTHAGED 455-456
  byte   ASTHDX 457-458
  byte   ASTHAGED 459-460
  byte   ASSTIL31 461-462
  byte   ASSTIL53 463-464
  byte   ASATAK31 465-466
  byte   ASATAK53 467-468
  byte   ASTHEP31 469-470
  byte   ASTHEP53 471-472
  byte   ASACUT53 473-474
  byte   ASMRCN53 475-476
  byte   ASPREV53 477-478
  byte   ASDALY53 479-480
  byte   ASPKFL53 481-482
  byte   ASEVFL53 483-484
  byte   ASWNFL53 485-486
  byte   ADHDADDX 487-488
  byte   ADHDAGED 489-490
  byte   PREGNT31 491-492
  byte   PREGNT42 493-494
  byte   PREGNT53 495-496
  byte   IADLHP31 497-498
  byte   IADLHP42 499-500
  byte   IADLHP53 501-502
  byte   IADL3M31 503-504
  byte   IADL3M42 505-506
  byte   IADL3M53 507-508
  byte   ADLHLP31 509-510
  byte   ADLHLP42 511-512
  byte   ADLHLP53 513-514
  byte   ADL3MO31 515-516
  byte   ADL3MO42 517-518
  byte   ADL3MO53 519-520
  byte   AIDHLP31 521-522
  byte   AIDHLP53 523-524
  byte   WLKLIM31 525-526
  byte   WLKLIM53 527-528
  byte   LFTDIF31 529-530
  byte   LFTDIF53 531-532
  byte   STPDIF31 533-534
  byte   STPDIF53 535-536
  byte   WLKDIF31 537-538
  byte   WLKDIF53 539-540
  byte   MILDIF31 541-542
  byte   MILDIF53 543-544
  byte   STNDIF31 545-546
  byte   STNDIF53 547-548
  byte   BENDIF31 549-550
  byte   BENDIF53 551-552
  byte   RCHDIF31 553-554
  byte   RCHDIF53 555-556
  byte   FNGRDF31 557-558
  byte   FNGRDF53 559-560
  byte   WLK3MO31 561-562
  byte   WLK3MO53 563-564
  byte   ACTLIM31 565-566
  byte   ACTLIM53 567-568
  byte   WRKLIM31 569-570
  byte   WRKLIM53 571-572
  byte   HSELIM31 573-574
  byte   HSELIM53 575-576
  byte   SCHLIM31 577-578
  byte   SCHLIM53 579-580
  byte   UNABLE31 581-582
  byte   UNABLE53 583-584
  byte   SOCLIM31 585-586
  byte   SOCLIM53 587-588
  byte   COGLIM31 589-590
  byte   COGLIM53 591-592
  byte   WRGLAS42 593-594
  byte   SEEDIF42 595-596
  byte   BLIND42 597-598
  byte   READNW42 599-600
  byte   RECPEP42 601-602
  byte   VISION42 603-604
  byte   HEARAD42 605-606
  byte   HEARDI42 607-608
  byte   DEAF42 609-610
  byte   HEARMO42 611-612
  byte   HEARSM42 613-614
  byte   HEARNG42 615-616
  byte   ANYLIM12 617-618
  byte   LSHLTH42 619-620
  byte   NEVILL42 621-622
  byte   SICEAS42 623-624
  byte   HLTHLF42 625-626
  byte   WRHLTH42 627-628
  byte   CHPMED42 629-630
  byte   CHPMHB42 631-632
  byte   CHPMCN42 633-634
  byte   CHSERV42 635-636
  byte   CHSRHB42 637-638
  byte   CHSRCN42 639-640
  byte   CHLIMI42 641-642
  byte   CHLIHB42 643-644
  byte   CHLICO42 645-646
  byte   CHTHER42 647-648
  byte   CHTHHB42 649-650
  byte   CHTHCO42 651-652
  byte   CHCOUN42 653-654
  byte   CHEMPB42 655-656
  byte   CSHCN42 657-658
  byte   MOMPRO42 659-660
  byte   DADPRO42 661-662
  byte   UNHAP42 663-664
  byte   SCHLBH42 665-666
  byte   HAVFUN42 667-668
  byte   ADUPRO42 669-670
  byte   NERVAF42 671-672
  byte   SIBPRO42 673-674
  byte   KIDPRO42 675-676
  byte   SPRPRO42 677-678
  byte   SCHPRO42 679-680
  byte   HOMEBH42 681-682
  byte   TRBLE42 683-684
  byte   CHILCR42 685-686
  byte   CHILWW42 687-688
  byte   CHRTCR42 689-690
  byte   CHRTWW42 691-692
  byte   CHAPPT42 693-694
  byte   CHNDCR42 695-696
  byte   CHENEC42 697-698
  byte   CHLIST42 699-700
  byte   CHEXPL42 701-702
  byte   CHRESP42 703-704
  byte   CHPRTM42 705-706
  byte   CHHECR42 707-708
  byte   CHSPEC42 709-710
  byte   CHEYRE42 711-712
  byte   MESHGT42 713-714
  byte   WHNHGT42 715-716
  byte   MESWGT42 717-718
  byte   WHNWGT42 719-720
  double CHBMIX42 721-725
  byte   MESVIS42 726-727
  byte   MESBPR42 728-729
  byte   WHNBPR42 730-731
  byte   DENTAL42 732-733
  byte   WHNDEN42 734-735
  byte   EATHLT42 736-737
  byte   WHNEAT42 738-739
  byte   PHYSCL42 740-741
  byte   WHNPHY42 742-743
  byte   SAFEST42 744-745
  byte   WHNSAF42 746-747
  byte   BOOST42 748-749
  byte   WHNBST42 750-751
  byte   LAPBLT42 752-753
  byte   WHNLAP42 754-755
  byte   HELMET42 756-757
  byte   WHNHEL42 758-759
  byte   NOSMOK42 760-761
  byte   WHNSMK42 762-763
  byte   TIMALN42 764-765
  byte   DENTCK53 766-767
  byte   BPCHEK53 768-769
  byte   BPMONT53 770-771
  byte   CHOLCK53 772-773
  byte   CHECK53 774-775
  byte   NOFAT53 776-777
  byte   EXRCIS53 778-779
  byte   FLUSHT53 780-781
  byte   ASPRIN53 782-783
  byte   NOASPR53 784-785
  byte   STOMCH53 786-787
  byte   LSTETH53 788-789
  byte   PSA53 790-791
  byte   HYSTER53 792-793
  byte   PAPSMR53 794-795
  byte   BRSTEX53 796-797
  byte   MAMOGR53 798-799
  byte   BSTST53 800-801
  byte   BSTSRE53 802-803
  byte   CLNTST53 804-805
  byte   CLNTRE53 806-807
  byte   SGMTST53 808-809
  byte   SGMTRE53 810-811
  byte   PHYEXE53 812-813
  double BMINDX53 814-818
  byte   SEATBE53 819-820
  byte   SAQELIG 821-821
  int    ADPRX42 822-824
  byte   ADILCR42 825-826
  byte   ADILWW42 827-828
  byte   ADRTCR42 829-830
  byte   ADRTWW42 831-832
  byte   ADAPPT42 833-834
  byte   ADNDCR42 835-836
  byte   ADEGMC42 837-838
  byte   ADLIST42 839-840
  byte   ADEXPL42 841-842
  byte   ADRESP42 843-844
  byte   ADPRTM42 845-846
  byte   ADINST42 847-848
  byte   ADEZUN42 849-850
  byte   ADTLHW42 851-852
  byte   ADFFRM42 853-854
  byte   ADFHLP42 855-856
  byte   ADHECR42 857-858
  byte   ADSMOK42 859-860
  byte   ADNSMK42 861-862
  byte   ADDRBP42 863-864
  byte   ADSPEC42 865-866
  byte   ADSPRF42 867-868
  byte   ADGENH42 869-870
  byte   ADDAYA42 871-872
  byte   ADCLIM42 873-874
  byte   ADPALS42 875-876
  byte   ADPWLM42 877-878
  byte   ADMALS42 879-880
  byte   ADMWLM42 881-882
  byte   ADPAIN42 883-884
  byte   ADCAPE42 885-886
  byte   ADNRGY42 887-888
  byte   ADDOWN42 889-890
  byte   ADSOCA42 891-892
  double PCS42 893-897
  double MCS42 898-902
  byte   SFFLAG42 903-904
  byte   ADNERV42 905-906
  byte   ADHOPE42 907-908
  byte   ADREST42 909-910
  byte   ADSAD42 911-912
  byte   ADEFRT42 913-914
  byte   ADWRTH42 915-916
  byte   K6SUM42 917-918
  byte   ADINTR42 919-920
  byte   ADDPRS42 921-922
  byte   PHQ242 923-924
  byte   ADINSA42 925-926
  byte   ADINSB42 927-928
  byte   ADRISK42 929-930
  byte   ADOVER42 931-932
  byte   ADCMPM42 933-934
  byte   ADCMPD42 935-936
  int    ADCMPY42 937-940
  byte   ADLANG42 941-942
  byte   DSDIA53 943-944
  byte   DSA1C53 945-946
  byte   DSFT1353 947-948
  byte   DSFT1253 949-950
  byte   DSFT1153 951-952
  byte   DSFB1153 953-954
  byte   DSFTNV53 955-956
  byte   DSEY1353 957-958
  byte   DSEY1253 959-960
  byte   DSEY1153 961-962
  byte   DSEB1153 963-964
  byte   DSEYNV53 965-966
  byte   DSCH1353 967-968
  byte   DSCH1253 969-970
  byte   DSCH1153 971-972
  byte   DSCB1153 973-974
  byte   DSCHNV53 975-976
  byte   DSFL1353 977-978
  byte   DSFL1253 979-980
  byte   DSFL1153 981-982
  byte   DSVB1153 983-984
  byte   DSFLNV53 985-986
  byte   DSKIDN53 987-988
  byte   DSEYPR53 989-990
  byte   DSDIET53 991-992
  byte   DSMED53 993-994
  byte   DSINSU53 995-996
  byte   DSCPCP53 997-998
  byte   DSCNPC53 999-1000
  byte   DSCPHN53 1001-1002
  byte   DSCINT53 1003-1004
  byte   DSCGRP53 1005-1006
  byte   DSCONF53 1007-1008
  byte   DSPRX53 1009-1010
  int    DDNWRK31 1011-1013
  int    DDNWRK42 1014-1016
  int    DDNWRK53 1017-1019
  byte   WKINBD31 1020-1021
  int    WKINBD42 1022-1024
  int    WKINBD53 1025-1027
  int    DDNSCL31 1028-1030
  int    DDNSCL42 1031-1033
  byte   DDNSCL53 1034-1035
  byte   SCLNBD31 1036-1037
  byte   SCLNBD42 1038-1039
  byte   SCLNBD53 1040-1041
  int    DDBDYS31 1042-1044
  int    DDBDYS42 1045-1047
  int    DDBDYS53 1048-1050
  byte   OTHDYS31 1051-1052
  byte   OTHDYS42 1053-1054
  byte   OTHDYS53 1055-1056
  byte   OTHNDD31 1057-1058
  int    OTHNDD42 1059-1061
  byte   OTHNDD53 1062-1063
  byte   ACCELI42 1064-1065
  byte   LANGHM42 1066-1067
  byte   ENGCMF42 1068-1069
  byte   ENGSPK42 1070-1071
  byte   USBORN42 1072-1073
  byte   USLIVE42 1074-1075
  byte   HAVEUS42 1076-1077
  byte   YNOUSC42 1078-1079
  byte   NOREAS42 1080-1081
  byte   SELDSI42 1082-1083
  byte   NEWARE42 1084-1085
  byte   DKWHRU42 1086-1087
  byte   USCNOT42 1088-1089
  byte   PERSLA42 1090-1091
  byte   DIFFPL42 1092-1093
  byte   INSRPL42 1094-1095
  byte   MYSELF42 1096-1097
  byte   CARECO42 1098-1099
  byte   NOHINS42 1100-1101
  byte   OTHINS42 1102-1103
  byte   JOBRSN42 1104-1105
  byte   NEWDOC42 1106-1107
  byte   DOCELS42 1108-1109
  byte   NOLIKE42 1110-1111
  byte   HEALTH42 1112-1113
  byte   KNOWDR42 1114-1115
  byte   ONJOB42 1116-1117
  byte   NOGODR42 1118-1119
  byte   TRANS42 1120-1121
  byte   CLINIC42 1122-1123
  byte   OTHREA42 1124-1125
  byte   PROVTY42 1126-1127
  byte   PLCTYP42 1128-1129
  byte   GOTOUS42 1130-1131
  byte   TMTKUS42 1132-1133
  byte   DFTOUS42 1134-1135
  byte   TYPEPE42 1136-1137
  byte   LOCATN42 1138-1139
  byte   HSPLAP42 1140-1141
  byte   WHITPR42 1142-1143
  byte   BLCKPR42 1144-1145
  byte   ASIANP42 1146-1147
  byte   NATAMP42 1148-1149
  byte   PACISP42 1150-1151
  byte   OTHRCP42 1152-1153
  byte   GENDRP42 1154-1155
  byte   MINORP42 1156-1157
  byte   PREVEN42 1158-1159
  byte   REFFRL42 1160-1161
  byte   ONGONG42 1162-1163
  byte   PHNREG42 1164-1165
  byte   OFFHOU42 1166-1167
  byte   AFTHOU42 1168-1169
  byte   TREATM42 1170-1171
  byte   RESPCT42 1172-1173
  byte   DECIDE42 1174-1175
  byte   EXPLOP42 1176-1177
  byte   LANGPR42 1178-1179
  byte   MDUNAB42 1180-1181
  byte   MDUNRS42 1182-1183
  byte   MDUNPR42 1184-1185
  byte   MDDLAY42 1186-1187
  byte   MDDLRS42 1188-1189
  byte   MDDLPR42 1190-1191
  byte   DNUNAB42 1192-1193
  byte   DNUNRS42 1194-1195
  byte   DNUNPR42 1196-1197
  byte   DNDLAY42 1198-1199
  byte   DNDLRS42 1200-1201
  byte   DNDLPR42 1202-1203
  byte   PMUNAB42 1204-1205
  byte   PMUNRS42 1206-1207
  byte   PMUNPR42 1208-1209
  byte   PMDLAY42 1210-1211
  byte   PMDLRS42 1212-1213
  byte   PMDLPR42 1214-1215
  byte   EMPST31 1216-1217
  byte   EMPST42 1218-1219
  byte   EMPST53 1220-1221
  byte   RNDFLG31 1222-1223
  byte   MORJOB31 1224-1225
  byte   MORJOB42 1226-1227
  byte   MORJOB53 1228-1229
  byte   EVRWRK 1230-1231
  double HRWG31X 1232-1237
  double HRWG42X 1238-1243
  double HRWG53X 1244-1249
  byte   HRWGIM31 1250-1250
  byte   HRWGIM42 1251-1251
  byte   HRWGIM53 1252-1252
  byte   HRHOW31 1253-1254
  byte   HRHOW42 1255-1256
  byte   HRHOW53 1257-1258
  byte   DIFFWG31 1259-1260
  byte   DIFFWG42 1261-1262
  byte   DIFFWG53 1263-1264
  double NHRWG31 1265-1270
  double NHRWG42 1271-1276
  double NHRWG53 1277-1282
  int    HOUR31 1283-1285
  int    HOUR42 1286-1288
  int    HOUR53 1289-1291
  byte   TEMPJB31 1292-1293
  byte   TEMPJB42 1294-1295
  byte   TEMPJB53 1296-1297
  byte   SSNLJB31 1298-1299
  byte   SSNLJB42 1300-1301
  byte   SSNLJB53 1302-1303
  byte   SELFCM31 1304-1305
  byte   SELFCM42 1306-1307
  byte   SELFCM53 1308-1309
  byte   DISVW31X 1310-1311
  byte   DISVW42X 1312-1313
  byte   DISVW53X 1314-1315
  byte   CHOIC31 1316-1317
  byte   CHOIC42 1318-1319
  byte   CHOIC53 1320-1321
  byte   INDCAT31 1322-1323
  byte   INDCAT42 1324-1325
  byte   INDCAT53 1326-1327
  int    NUMEMP31 1328-1330
  int    NUMEMP42 1331-1333
  int    NUMEMP53 1334-1336
  byte   MORE31 1337-1338
  byte   MORE42 1339-1340
  byte   MORE53 1341-1342
  byte   UNION31 1343-1344
  byte   UNION42 1345-1346
  byte   UNION53 1347-1348
  byte   NWK31 1349-1350
  byte   NWK42 1351-1352
  byte   NWK53 1353-1354
  byte   CHGJ3142 1355-1356
  byte   CHGJ4253 1357-1358
  byte   YCHJ3142 1359-1360
  byte   YCHJ4253 1361-1362
  byte   STJBMM31 1363-1364
  byte   STJBDD31 1365-1366
  int    STJBYY31 1367-1370
  byte   STJBMM42 1371-1372
  byte   STJBDD42 1373-1374
  int    STJBYY42 1375-1378
  byte   STJBMM53 1379-1380
  byte   STJBDD53 1381-1382
  int    STJBYY53 1383-1386
  byte   EVRETIRE 1387-1388
  byte   OCCCAT31 1389-1390
  byte   OCCCAT42 1391-1392
  byte   OCCCAT53 1393-1394
  byte   PAYVAC31 1395-1396
  byte   PAYVAC42 1397-1398
  byte   PAYVAC53 1399-1400
  byte   SICPAY31 1401-1402
  byte   SICPAY42 1403-1404
  byte   SICPAY53 1405-1406
  byte   PAYDR31 1407-1408
  byte   PAYDR42 1409-1410
  byte   PAYDR53 1411-1412
  byte   RETPLN31 1413-1414
  byte   RETPLN42 1415-1416
  byte   RETPLN53 1417-1418
  byte   BSNTY31 1419-1420
  byte   BSNTY42 1421-1422
  byte   BSNTY53 1423-1424
  byte   JOBORG31 1425-1426
  byte   JOBORG42 1427-1428
  byte   JOBORG53 1429-1430
  byte   HELD31X 1431-1432
  byte   HELD42X 1433-1434
  byte   HELD53X 1435-1436
  byte   OFFER31X 1437-1438
  byte   OFFER42X 1439-1440
  byte   OFFER53X 1441-1442
  byte   OFREMP31 1443-1444
  byte   OFREMP42 1445-1446
  byte   OFREMP53 1447-1448
  byte   YNOINS31 1449-1450
  byte   YNOINS42 1451-1452
  byte   YNOINS53 1453-1454
  byte   SSIDIS12 1455-1456
  byte   AFDC12 1457-1458
  byte   FILEDR12 1459-1460
  byte   WILFIL12 1461-1462
  byte   FLSTAT12 1463-1464
  byte   FILER12 1465-1466
  byte   JTINRU12 1467-1468
  int    JNTPID12 1469-1471
  byte   CLMDEP12 1472-1473
  byte   DEPDNT12 1474-1475
  byte   DPINRU12 1476-1477
  byte   DPOTSD12 1478-1479
  byte   TAXFRM12 1480-1481
  byte   DEDUCT12 1482-1483
  long   TOTDED12 1484-1489
  byte   CLMHIP12 1490-1491
  byte   EICRDT12 1492-1493
  byte   FOODST12 1494-1495
  byte   FOODMN12 1496-1497
  int    FOODVL12 1498-1501
  long   TTLP12X 1502-1507
  long   FAMINC12 1508-1513
  byte   POVCAT12 1514-1514
  double POVLEV12 1515-1525
  long   WAGEP12X 1526-1531
  byte   WAGIMP12 1532-1532
  long   BUSNP12X 1533-1538
  byte   BUSIMP12 1539-1539
  long   UNEMP12X 1540-1544
  byte   UNEIMP12 1545-1545
  long   WCMPP12X 1546-1550
  byte   WCPIMP12 1551-1551
  long   INTRP12X 1552-1556
  byte   INTIMP12 1557-1557
  long   DIVDP12X 1558-1562
  byte   DIVIMP12 1563-1563
  long   SALEP12X 1564-1570
  byte   SALIMP12 1571-1571
  long   PENSP12X 1572-1576
  byte   PENIMP12 1577-1577
  long   SSECP12X 1578-1582
  byte   SSCIMP12 1583-1583
  long   TRSTP12X 1584-1589
  byte   TRTIMP12 1590-1590
  long   VETSP12X 1591-1595
  byte   VETIMP12 1596-1596
  long   IRASP12X 1597-1601
  byte   IRAIMP12 1602-1602
  long   REFDP12X 1603-1607
  byte   REFIMP12 1608-1608
  long   ALIMP12X 1609-1613
  byte   ALIIMP12 1614-1614
  long   CHLDP12X 1615-1619
  byte   CHLIMP12 1620-1620
  long   CASHP12X 1621-1626
  byte   CSHIMP12 1627-1627
  long   SSIP12X 1628-1632
  byte   SSIIMP12 1633-1633
  int    PUBP12X 1634-1637
  byte   PUBIMP12 1638-1638
  long   OTHRP12X 1639-1643
  byte   OTHIMP12 1644-1644
  str    HIEUIDX 1645-1651
  byte   TRIJA12X 1652-1653
  byte   TRIFE12X 1654-1655
  byte   TRIMA12X 1656-1657
  byte   TRIAP12X 1658-1659
  byte   TRIMY12X 1660-1661
  byte   TRIJU12X 1662-1663
  byte   TRIJL12X 1664-1665
  byte   TRIAU12X 1666-1667
  byte   TRISE12X 1668-1669
  byte   TRIOC12X 1670-1671
  byte   TRINO12X 1672-1673
  byte   TRIDE12X 1674-1675
  byte   MCRJA12 1676-1677
  byte   MCRFE12 1678-1679
  byte   MCRMA12 1680-1681
  byte   MCRAP12 1682-1683
  byte   MCRMY12 1684-1685
  byte   MCRJU12 1686-1687
  byte   MCRJL12 1688-1689
  byte   MCRAU12 1690-1691
  byte   MCRSE12 1692-1693
  byte   MCROC12 1694-1695
  byte   MCRNO12 1696-1697
  byte   MCRDE12 1698-1699
  byte   MCRJA12X 1700-1701
  byte   MCRFE12X 1702-1703
  byte   MCRMA12X 1704-1705
  byte   MCRAP12X 1706-1707
  byte   MCRMY12X 1708-1709
  byte   MCRJU12X 1710-1711
  byte   MCRJL12X 1712-1713
  byte   MCRAU12X 1714-1715
  byte   MCRSE12X 1716-1717
  byte   MCROC12X 1718-1719
  byte   MCRNO12X 1720-1721
  byte   MCRDE12X 1722-1723
  byte   MCDJA12 1724-1725
  byte   MCDFE12 1726-1727
  byte   MCDMA12 1728-1729
  byte   MCDAP12 1730-1731
  byte   MCDMY12 1732-1733
  byte   MCDJU12 1734-1735
  byte   MCDJL12 1736-1737
  byte   MCDAU12 1738-1739
  byte   MCDSE12 1740-1741
  byte   MCDOC12 1742-1743
  byte   MCDNO12 1744-1745
  byte   MCDDE12 1746-1747
  byte   MCDJA12X 1748-1749
  byte   MCDFE12X 1750-1751
  byte   MCDMA12X 1752-1753
  byte   MCDAP12X 1754-1755
  byte   MCDMY12X 1756-1757
  byte   MCDJU12X 1758-1759
  byte   MCDJL12X 1760-1761
  byte   MCDAU12X 1762-1763
  byte   MCDSE12X 1764-1765
  byte   MCDOC12X 1766-1767
  byte   MCDNO12X 1768-1769
  byte   MCDDE12X 1770-1771
  byte   OPAJA12 1772-1773
  byte   OPAFE12 1774-1775
  byte   OPAMA12 1776-1777
  byte   OPAAP12 1778-1779
  byte   OPAMY12 1780-1781
  byte   OPAJU12 1782-1783
  byte   OPAJL12 1784-1785
  byte   OPAAU12 1786-1787
  byte   OPASE12 1788-1789
  byte   OPAOC12 1790-1791
  byte   OPANO12 1792-1793
  byte   OPADE12 1794-1795
  byte   OPBJA12 1796-1797
  byte   OPBFE12 1798-1799
  byte   OPBMA12 1800-1801
  byte   OPBAP12 1802-1803
  byte   OPBMY12 1804-1805
  byte   OPBJU12 1806-1807
  byte   OPBJL12 1808-1809
  byte   OPBAU12 1810-1811
  byte   OPBSE12 1812-1813
  byte   OPBOC12 1814-1815
  byte   OPBNO12 1816-1817
  byte   OPBDE12 1818-1819
  byte   STAJA12 1820-1821
  byte   STAFE12 1822-1823
  byte   STAMA12 1824-1825
  byte   STAAP12 1826-1827
  byte   STAMY12 1828-1829
  byte   STAJU12 1830-1831
  byte   STAJL12 1832-1833
  byte   STAAU12 1834-1835
  byte   STASE12 1836-1837
  byte   STAOC12 1838-1839
  byte   STANO12 1840-1841
  byte   STADE12 1842-1843
  byte   PUBJA12X 1844-1845
  byte   PUBFE12X 1846-1847
  byte   PUBMA12X 1848-1849
  byte   PUBAP12X 1850-1851
  byte   PUBMY12X 1852-1853
  byte   PUBJU12X 1854-1855
  byte   PUBJL12X 1856-1857
  byte   PUBAU12X 1858-1859
  byte   PUBSE12X 1860-1861
  byte   PUBOC12X 1862-1863
  byte   PUBNO12X 1864-1865
  byte   PUBDE12X 1866-1867
  byte   PEGJA12 1868-1869
  byte   PEGFE12 1870-1871
  byte   PEGMA12 1872-1873
  byte   PEGAP12 1874-1875
  byte   PEGMY12 1876-1877
  byte   PEGJU12 1878-1879
  byte   PEGJL12 1880-1881
  byte   PEGAU12 1882-1883
  byte   PEGSE12 1884-1885
  byte   PEGOC12 1886-1887
  byte   PEGNO12 1888-1889
  byte   PEGDE12 1890-1891
  byte   PDKJA12 1892-1893
  byte   PDKFE12 1894-1895
  byte   PDKMA12 1896-1897
  byte   PDKAP12 1898-1899
  byte   PDKMY12 1900-1901
  byte   PDKJU12 1902-1903
  byte   PDKJL12 1904-1905
  byte   PDKAU12 1906-1907
  byte   PDKSE12 1908-1909
  byte   PDKOC12 1910-1911
  byte   PDKNO12 1912-1913
  byte   PDKDE12 1914-1915
  byte   PNGJA12 1916-1917
  byte   PNGFE12 1918-1919
  byte   PNGMA12 1920-1921
  byte   PNGAP12 1922-1923
  byte   PNGMY12 1924-1925
  byte   PNGJU12 1926-1927
  byte   PNGJL12 1928-1929
  byte   PNGAU12 1930-1931
  byte   PNGSE12 1932-1933
  byte   PNGOC12 1934-1935
  byte   PNGNO12 1936-1937
  byte   PNGDE12 1938-1939
  byte   POGJA12 1940-1941
  byte   POGFE12 1942-1943
  byte   POGMA12 1944-1945
  byte   POGAP12 1946-1947
  byte   POGMY12 1948-1949
  byte   POGJU12 1950-1951
  byte   POGJL12 1952-1953
  byte   POGAU12 1954-1955
  byte   POGSE12 1956-1957
  byte   POGOC12 1958-1959
  byte   POGNO12 1960-1961
  byte   POGDE12 1962-1963
  byte   PRSJA12 1964-1965
  byte   PRSFE12 1966-1967
  byte   PRSMA12 1968-1969
  byte   PRSAP12 1970-1971
  byte   PRSMY12 1972-1973
  byte   PRSJU12 1974-1975
  byte   PRSJL12 1976-1977
  byte   PRSAU12 1978-1979
  byte   PRSSE12 1980-1981
  byte   PRSOC12 1982-1983
  byte   PRSNO12 1984-1985
  byte   PRSDE12 1986-1987
  byte   POUJA12 1988-1989
  byte   POUFE12 1990-1991
  byte   POUMA12 1992-1993
  byte   POUAP12 1994-1995
  byte   POUMY12 1996-1997
  byte   POUJU12 1998-1999
  byte   POUJL12 2000-2001
  byte   POUAU12 2002-2003
  byte   POUSE12 2004-2005
  byte   POUOC12 2006-2007
  byte   POUNO12 2008-2009
  byte   POUDE12 2010-2011
  byte   PRIJA12 2012-2013
  byte   PRIFE12 2014-2015
  byte   PRIMA12 2016-2017
  byte   PRIAP12 2018-2019
  byte   PRIMY12 2020-2021
  byte   PRIJU12 2022-2023
  byte   PRIJL12 2024-2025
  byte   PRIAU12 2026-2027
  byte   PRISE12 2028-2029
  byte   PRIOC12 2030-2031
  byte   PRINO12 2032-2033
  byte   PRIDE12 2034-2035
  byte   HPEJA12 2036-2037
  byte   HPEFE12 2038-2039
  byte   HPEMA12 2040-2041
  byte   HPEAP12 2042-2043
  byte   HPEMY12 2044-2045
  byte   HPEJU12 2046-2047
  byte   HPEJL12 2048-2049
  byte   HPEAU12 2050-2051
  byte   HPESE12 2052-2053
  byte   HPEOC12 2054-2055
  byte   HPENO12 2056-2057
  byte   HPEDE12 2058-2059
  byte   HPDJA12 2060-2061
  byte   HPDFE12 2062-2063
  byte   HPDMA12 2064-2065
  byte   HPDAP12 2066-2067
  byte   HPDMY12 2068-2069
  byte   HPDJU12 2070-2071
  byte   HPDJL12 2072-2073
  byte   HPDAU12 2074-2075
  byte   HPDSE12 2076-2077
  byte   HPDOC12 2078-2079
  byte   HPDNO12 2080-2081
  byte   HPDDE12 2082-2083
  byte   HPNJA12 2084-2085
  byte   HPNFE12 2086-2087
  byte   HPNMA12 2088-2089
  byte   HPNAP12 2090-2091
  byte   HPNMY12 2092-2093
  byte   HPNJU12 2094-2095
  byte   HPNJL12 2096-2097
  byte   HPNAU12 2098-2099
  byte   HPNSE12 2100-2101
  byte   HPNOC12 2102-2103
  byte   HPNNO12 2104-2105
  byte   HPNDE12 2106-2107
  byte   HPOJA12 2108-2109
  byte   HPOFE12 2110-2111
  byte   HPOMA12 2112-2113
  byte   HPOAP12 2114-2115
  byte   HPOMY12 2116-2117
  byte   HPOJU12 2118-2119
  byte   HPOJL12 2120-2121
  byte   HPOAU12 2122-2123
  byte   HPOSE12 2124-2125
  byte   HPOOC12 2126-2127
  byte   HPONO12 2128-2129
  byte   HPODE12 2130-2131
  byte   HPSJA12 2132-2133
  byte   HPSFE12 2134-2135
  byte   HPSMA12 2136-2137
  byte   HPSAP12 2138-2139
  byte   HPSMY12 2140-2141
  byte   HPSJU12 2142-2143
  byte   HPSJL12 2144-2145
  byte   HPSAU12 2146-2147
  byte   HPSSE12 2148-2149
  byte   HPSOC12 2150-2151
  byte   HPSNO12 2152-2153
  byte   HPSDE12 2154-2155
  byte   HPRJA12 2156-2157
  byte   HPRFE12 2158-2159
  byte   HPRMA12 2160-2161
  byte   HPRAP12 2162-2163
  byte   HPRMY12 2164-2165
  byte   HPRJU12 2166-2167
  byte   HPRJL12 2168-2169
  byte   HPRAU12 2170-2171
  byte   HPRSE12 2172-2173
  byte   HPROC12 2174-2175
  byte   HPRNO12 2176-2177
  byte   HPRDE12 2178-2179
  byte   INSJA12X 2180-2181
  byte   INSFE12X 2182-2183
  byte   INSMA12X 2184-2185
  byte   INSAP12X 2186-2187
  byte   INSMY12X 2188-2189
  byte   INSJU12X 2190-2191
  byte   INSJL12X 2192-2193
  byte   INSAU12X 2194-2195
  byte   INSSE12X 2196-2197
  byte   INSOC12X 2198-2199
  byte   INSNO12X 2200-2201
  byte   INSDE12X 2202-2203
  byte   PRVEV12 2204-2204
  byte   TRIEV12 2205-2205
  byte   MCREV12 2206-2206
  byte   MCDEV12 2207-2207
  byte   OPAEV12 2208-2208
  byte   OPBEV12 2209-2209
  byte   UNINS12 2210-2210
  byte   INSCOV12 2211-2211
  byte   INSURC12 2212-2212
  byte   TRIST31X 2213-2214
  byte   TRIST42X 2215-2216
  byte   TRIST12X 2217-2218
  byte   TRIPR31X 2219-2220
  byte   TRIPR42X 2221-2222
  byte   TRIPR12X 2223-2224
  byte   TRIEX31X 2225-2226
  byte   TRIEX42X 2227-2228
  byte   TRIEX12X 2229-2230
  byte   TRILI31X 2231-2232
  byte   TRILI42X 2233-2234
  byte   TRILI12X 2235-2236
  byte   TRICH31X 2237-2238
  byte   TRICH42X 2239-2240
  byte   TRICH12X 2241-2242
  byte   MCRPD31 2243-2244
  byte   MCRPD42 2245-2246
  byte   MCRPD12 2247-2248
  byte   MCRPD31X 2249-2250
  byte   MCRPD42X 2251-2252
  byte   MCRPD12X 2253-2254
  byte   MCRPB31 2255-2256
  byte   MCRPB42 2257-2258
  byte   MCRPB12 2259-2260
  byte   MCRPHO31 2261-2262
  byte   MCRPHO42 2263-2264
  byte   MCRPHO12 2265-2266
  byte   MCDHMO31 2267-2268
  byte   MCDHMO42 2269-2270
  byte   MCDHMO12 2271-2272
  byte   MCDMC31 2273-2274
  byte   MCDMC42 2275-2276
  byte   MCDMC12 2277-2278
  byte   PRVHMO31 2279-2280
  byte   PRVHMO42 2281-2282
  byte   PRVHMO12 2283-2284
  byte   PRVMNC31 2285-2286
  byte   PRVMNC42 2287-2288
  byte   PRVMNC12 2289-2290
  byte   PRVDRL31 2291-2292
  byte   PRVDRL42 2293-2294
  byte   PRVDRL12 2295-2296
  byte   PHMONP31 2297-2298
  byte   PHMONP42 2299-2300
  byte   PHMONP12 2301-2302
  byte   PMNCNP31 2303-2304
  byte   PMNCNP42 2305-2306
  byte   PMNCNP12 2307-2308
  byte   PRDRNP31 2309-2310
  byte   PRDRNP42 2311-2312
  byte   PRDRNP12 2313-2314
  byte   FSAGT31 2315-2316
  byte   HASFSA31 2317-2318
  double FSAAMT31 2319-2326
  byte   PREVCOVR 2327-2328
  byte   COVRMM 2329-2330
  int    COVRYY 2331-2334
  byte   WASESTB 2335-2336
  byte   WASMCARE 2337-2338
  byte   WASMCAID 2339-2340
  byte   WASCHAMP 2341-2342
  byte   WASVA 2343-2344
  byte   WASPRIV 2345-2346
  byte   WASOTGOV 2347-2348
  byte   WASAFDC 2349-2350
  byte   WASSSI 2351-2352
  byte   WASSTAT1 2353-2354
  byte   WASSTAT2 2355-2356
  byte   WASSTAT3 2357-2358
  byte   WASSTAT4 2359-2360
  byte   WASOTHER 2361-2362
  byte   NOINSBEF 2363-2364
  byte   NOINSTM 2365-2366
  byte   NOINUNIT 2367-2368
  byte   MORECOVR 2369-2370
  byte   INSENDMM 2371-2372
  int    INSENDYY 2373-2376
  byte   TRICR31X 2377-2378
  byte   TRICR42X 2379-2380
  byte   TRICR53X 2381-2382
  byte   TRICR12X 2383-2384
  byte   TRIAT31X 2385-2386
  byte   TRIAT42X 2387-2388
  byte   TRIAT53X 2389-2390
  byte   TRIAT12X 2391-2392
  byte   MCAID31 2393-2394
  byte   MCAID42 2395-2396
  byte   MCAID53 2397-2398
  byte   MCAID12 2399-2400
  byte   MCAID31X 2401-2402
  byte   MCAID42X 2403-2404
  byte   MCAID53X 2405-2406
  byte   MCAID12X 2407-2408
  byte   MCARE31 2409-2410
  byte   MCARE42 2411-2412
  byte   MCARE53 2413-2414
  byte   MCARE12 2415-2416
  byte   MCARE31X 2417-2418
  byte   MCARE42X 2419-2420
  byte   MCARE53X 2421-2422
  byte   MCARE12X 2423-2424
  byte   MCDAT31X 2425-2426
  byte   MCDAT42X 2427-2428
  byte   MCDAT53X 2429-2430
  byte   MCDAT12X 2431-2432
  byte   OTPAAT31 2433-2434
  byte   OTPAAT42 2435-2436
  byte   OTPAAT53 2437-2438
  byte   OTPAAT12 2439-2440
  byte   OTPBAT31 2441-2442
  byte   OTPBAT42 2443-2444
  byte   OTPBAT53 2445-2446
  byte   OTPBAT12 2447-2448
  byte   OTPUBA31 2449-2450
  byte   OTPUBA42 2451-2452
  byte   OTPUBA53 2453-2454
  byte   OTPUBA12 2455-2456
  byte   OTPUBB31 2457-2458
  byte   OTPUBB42 2459-2460
  byte   OTPUBB53 2461-2462
  byte   OTPUBB12 2463-2464
  byte   PRIDK31 2465-2466
  byte   PRIDK42 2467-2468
  byte   PRIDK53 2469-2470
  byte   PRIDK12 2471-2472
  byte   PRIEU31 2473-2474
  byte   PRIEU42 2475-2476
  byte   PRIEU53 2477-2478
  byte   PRIEU12 2479-2480
  byte   PRING31 2481-2482
  byte   PRING42 2483-2484
  byte   PRING53 2485-2486
  byte   PRING12 2487-2488
  byte   PRIOG31 2489-2490
  byte   PRIOG42 2491-2492
  byte   PRIOG53 2493-2494
  byte   PRIOG12 2495-2496
  byte   PRIS31 2497-2498
  byte   PRIS42 2499-2500
  byte   PRIS53 2501-2502
  byte   PRIS12 2503-2504
  byte   PRIV31 2505-2506
  byte   PRIV42 2507-2508
  byte   PRIV53 2509-2510
  byte   PRIV12 2511-2512
  byte   PRIVAT31 2513-2514
  byte   PRIVAT42 2515-2516
  byte   PRIVAT53 2517-2518
  byte   PRIVAT12 2519-2520
  byte   PROUT31 2521-2522
  byte   PROUT42 2523-2524
  byte   PROUT53 2525-2526
  byte   PROUT12 2527-2528
  byte   PUB31X 2529-2530
  byte   PUB42X 2531-2532
  byte   PUB53X 2533-2534
  byte   PUB12X 2535-2536
  byte   PUBAT31X 2537-2538
  byte   PUBAT42X 2539-2540
  byte   PUBAT53X 2541-2542
  byte   PUBAT12X 2543-2544
  byte   INS31X 2545-2546
  byte   INS42X 2547-2548
  byte   INS53X 2549-2550
  byte   INS12X 2551-2552
  byte   INSAT31X 2553-2554
  byte   INSAT42X 2555-2556
  byte   INSAT53X 2557-2558
  byte   INSAT12X 2559-2560
  byte   STAPR31 2561-2562
  byte   STAPR42 2563-2564
  byte   STAPR53 2565-2566
  byte   STAPR12 2567-2568
  byte   STPRAT31 2569-2570
  byte   STPRAT42 2571-2572
  byte   STPRAT53 2573-2574
  byte   STPRAT12 2575-2576
  byte   DENTIN31 2577-2578
  byte   DENTIN42 2579-2580
  byte   DENTIN53 2581-2582
  byte   DNTINS31 2583-2584
  byte   DNTINS12 2585-2586
  byte   PMEDIN31 2587-2588
  byte   PMEDIN42 2589-2590
  byte   PMEDIN53 2591-2592
  byte   PMDINS31 2593-2594
  byte   PMDINS12 2595-2596
  byte   PMEDUP31 2597-2598
  byte   PMEDUP42 2599-2600
  byte   PMEDUP53 2601-2602
  byte   PMEDPY31 2603-2604
  byte   PMEDPY42 2605-2606
  byte   PMEDPY53 2607-2608
  double PMEDPP31 2609-2615
  double PMEDPP42 2616-2622
  double PMEDPP53 2623-2629
  byte   GDCPBM42 2630-2631
  byte   APRTRM42 2632-2633
  byte   APRDLM42 2634-2635
  byte   LKINFM42 2636-2637
  byte   PBINFM42 2638-2639
  byte   CSTSVM42 2640-2641
  byte   PBSVCM42 2642-2643
  byte   PPRWKM42 2644-2645
  byte   PBPWKM42 2646-2647
  byte   RTPLNM42 2648-2649
  byte   GDCPBT42 2650-2651
  byte   APRTRT42 2652-2653
  byte   APRDLT42 2654-2655
  byte   LKINFT42 2656-2657
  byte   PBINFT42 2658-2659
  byte   CSTSVT42 2660-2661
  byte   PBSVCT42 2662-2663
  byte   PPRWKT42 2664-2665
  byte   PBPWKT42 2666-2667
  byte   RTPLNT42 2668-2669
  long   TOTTCH12 2670-2676
  long   TOTEXP12 2677-2682
  long   TOTSLF12 2683-2688
  long   TOTMCR12 2689-2694
  long   TOTMCD12 2695-2700
  long   TOTPRV12 2701-2706
  long   TOTVA12 2707-2712
  long   TOTTRI12 2713-2717
  long   TOTOFD12 2718-2722
  long   TOTSTL12 2723-2728
  long   TOTWCP12 2729-2733
  long   TOTOPR12 2734-2738
  long   TOTOPU12 2739-2743
  long   TOTOSR12 2744-2748
  long   TOTPTR12 2749-2754
  long   TOTOTH12 2755-2760
  int    OBTOTV12 2761-2763
  long   OBVTCH12 2764-2769
  long   OBVEXP12 2770-2774
  long   OBVSLF12 2775-2779
  long   OBVMCR12 2780-2784
  long   OBVMCD12 2785-2789
  long   OBVPRV12 2790-2794
  long   OBVVA12 2795-2799
  long   OBVTRI12 2800-2804
  int    OBVOFD12 2805-2808
  long   OBVSTL12 2809-2813
  long   OBVWCP12 2814-2818
  long   OBVOPR12 2819-2823
  int    OBVOPU12 2824-2827
  long   OBVOSR12 2828-2832
  long   OBVPTR12 2833-2837
  long   OBVOTH12 2838-2842
  int    OBDRV12 2843-2845
  long   OBDTCH12 2846-2851
  long   OBDEXP12 2852-2856
  long   OBDSLF12 2857-2861
  long   OBDMCR12 2862-2866
  long   OBDMCD12 2867-2871
  long   OBDPRV12 2872-2876
  long   OBDVA12 2877-2881
  long   OBDTRI12 2882-2886
  int    OBDOFD12 2887-2890
  long   OBDSTL12 2891-2895
  long   OBDWCP12 2896-2900
  long   OBDOPR12 2901-2905
  int    OBDOPU12 2906-2909
  long   OBDOSR12 2910-2914
  long   OBDPTR12 2915-2919
  long   OBDOTH12 2920-2924
  int    OBOTHV12 2925-2927
  long   OBOTCH12 2928-2933
  long   OBOEXP12 2934-2938
  int    OBOSLF12 2939-2942
  long   OBOMCR12 2943-2947
  long   OBOMCD12 2948-2952
  long   OBOPRV12 2953-2957
  long   OBOVA12 2958-2962
  long   OBOTRI12 2963-2967
  int    OBOOFD12 2968-2971
  long   OBOSTL12 2972-2976
  long   OBOWCP12 2977-2981
  long   OBOOPR12 2982-2986
  int    OBOOPU12 2987-2990
  long   OBOOSR12 2991-2995
  long   OBOPTR12 2996-3000
  long   OBOOTH12 3001-3005
  byte   OBCHIR12 3006-3007
  long   OBCTCH12 3008-3012
  long   OBCEXP12 3013-3017
  int    OBCSLF12 3018-3021
  int    OBCMCR12 3022-3025
  int    OBCMCD12 3026-3029
  long   OBCPRV12 3030-3034
  int    OBCVA12 3035-3037
  int    OBCTRI12 3038-3041
  byte   OBCOFD12 3042-3042
  int    OBCSTL12 3043-3045
  int    OBCWCP12 3046-3049
  int    OBCOPR12 3050-3053
  byte   OBCOPU12 3054-3054
  long   OBCOSR12 3055-3059
  long   OBCPTR12 3060-3064
  long   OBCOTH12 3065-3069
  int    OBNURS12 3070-3072
  long   OBNTCH12 3073-3078
  long   OBNEXP12 3079-3083
  int    OBNSLF12 3084-3087
  long   OBNMCR12 3088-3092
  int    OBNMCD12 3093-3096
  long   OBNPRV12 3097-3101
  long   OBNVA12 3102-3106
  int    OBNTRI12 3107-3110
  int    OBNOFD12 3111-3114
  int    OBNSTL12 3115-3118
  int    OBNWCP12 3119-3122
  long   OBNOPR12 3123-3127
  int    OBNOPU12 3128-3130
  long   OBNOSR12 3131-3135
  long   OBNPTR12 3136-3140
  long   OBNOTH12 3141-3145
  byte   OBOPTO12 3146-3147
  int    OBETCH12 3148-3151
  int    OBEEXP12 3152-3155
  int    OBESLF12 3156-3159
  int    OBEMCR12 3160-3163
  int    OBEMCD12 3164-3166
  int    OBEPRV12 3167-3170
  int    OBEVA12 3171-3173
  int    OBETRI12 3174-3176
  int    OBEOFD12 3177-3179
  int    OBESTL12 3180-3182
  byte   OBEWCP12 3183-3183
  int    OBEOPR12 3184-3187
  byte   OBEOPU12 3188-3189
  int    OBEOSR12 3190-3192
  int    OBEPTR12 3193-3196
  int    OBEOTH12 3197-3200
  byte   OBASST12 3201-3202
  long   OBATCH12 3203-3207
  int    OBAEXP12 3208-3211
  int    OBASLF12 3212-3214
  int    OBAMCR12 3215-3218
  int    OBAMCD12 3219-3222
  int    OBAPRV12 3223-3226
  int    OBAVA12 3227-3230
  int    OBATRI12 3231-3234
  int    OBAOFD12 3235-3237
  int    OBASTL12 3238-3240
  int    OBAWCP12 3241-3244
  int    OBAOPR12 3245-3247
  int    OBAOPU12 3248-3250
  int    OBAOSR12 3251-3253
  int    OBAPTR12 3254-3257
  int    OBAOTH12 3258-3260
  int    OBTHER12 3261-3263
  long   OBTTCH12 3264-3268
  long   OBTEXP12 3269-3273
  int    OBTSLF12 3274-3277
  long   OBTMCR12 3278-3282
  long   OBTMCD12 3283-3287
  long   OBTPRV12 3288-3292
  long   OBTVA12 3293-3297
  long   OBTTRI12 3298-3302
  int    OBTOFD12 3303-3305
  int    OBTSTL12 3306-3309
  long   OBTWCP12 3310-3314
  long   OBTOPR12 3315-3319
  int    OBTOPU12 3320-3322
  long   OBTOSR12 3323-3327
  long   OBTPTR12 3328-3332
  long   OBTOTH12 3333-3337
  int    OPTOTV12 3338-3340
  long   OPTTCH12 3341-3346
  long   OPTEXP12 3347-3352
  long   OPTSLF12 3353-3357
  long   OPTMCR12 3358-3362
  long   OPTMCD12 3363-3367
  long   OPTPRV12 3368-3373
  long   OPTVA12 3374-3378
  int    OPTTRI12 3379-3382
  long   OPTOFD12 3383-3387
  int    OPTSTL12 3388-3391
  long   OPTWCP12 3392-3396
  long   OPTOPR12 3397-3401
  int    OPTOPU12 3402-3405
  long   OPTOSR12 3406-3410
  long   OPTPTR12 3411-3416
  long   OPTOTH12 3417-3421
  long   OPFTCH12 3422-3427
  long   OPFEXP12 3428-3433
  long   OPFSLF12 3434-3438
  long   OPFMCR12 3439-3443
  long   OPFMCD12 3444-3448
  long   OPFPRV12 3449-3454
  long   OPFVA12 3455-3459
  int    OPFTRI12 3460-3463
  long   OPFOFD12 3464-3468
  int    OPFSTL12 3469-3472
  long   OPFWCP12 3473-3477
  long   OPFOPR12 3478-3482
  int    OPFOPU12 3483-3486
  long   OPFOSR12 3487-3491
  long   OPFPTR12 3492-3497
  long   OPFOTH12 3498-3502
  long   OPDEXP12 3503-3507
  long   OPDTCH12 3508-3513
  int    OPDSLF12 3514-3517
  long   OPDMCR12 3518-3522
  int    OPDMCD12 3523-3526
  long   OPDPRV12 3527-3531
  int    OPDVA12 3532-3535
  int    OPDTRI12 3536-3539
  byte   OPDOFD12 3540-3540
  int    OPDSTL12 3541-3543
  long   OPDWCP12 3544-3548
  int    OPDOPR12 3549-3552
  int    OPDOPU12 3553-3555
  int    OPDOSR12 3556-3559
  long   OPDPTR12 3560-3564
  int    OPDOTH12 3565-3568
  int    OPDRV12 3569-3571
  long   OPVTCH12 3572-3577
  long   OPVEXP12 3578-3583
  long   OPVSLF12 3584-3588
  long   OPVMCR12 3589-3593
  long   OPVMCD12 3594-3598
  long   OPVPRV12 3599-3604
  long   OPVVA12 3605-3609
  int    OPVTRI12 3610-3613
  long   OPVOFD12 3614-3618
  int    OPVSTL12 3619-3622
  long   OPVWCP12 3623-3627
  int    OPVOPR12 3628-3631
  int    OPVOPU12 3632-3635
  long   OPVOSR12 3636-3640
  long   OPVPTR12 3641-3646
  long   OPVOTH12 3647-3651
  long   OPSEXP12 3652-3656
  long   OPSTCH12 3657-3662
  int    OPSSLF12 3663-3666
  int    OPSMCR12 3667-3670
  int    OPSMCD12 3671-3674
  long   OPSPRV12 3675-3679
  int    OPSVA12 3680-3683
  int    OPSTRI12 3684-3687
  byte   OPSOFD12 3688-3688
  int    OPSSTL12 3689-3691
  long   OPSWCP12 3692-3696
  int    OPSOPR12 3697-3700
  int    OPSOPU12 3701-3703
  int    OPSOSR12 3704-3707
  long   OPSPTR12 3708-3712
  int    OPSOTH12 3713-3716
  byte   OPOTHV12 3717-3718
  long   OPOTCH12 3719-3724
  long   OPOEXP12 3725-3729
  int    OPOSLF12 3730-3733
  long   OPOMCR12 3734-3738
  long   OPOMCD12 3739-3743
  long   OPOPRV12 3744-3748
  long   OPOVA12 3749-3753
  int    OPOTRI12 3754-3757
  int    OPOOFD12 3758-3761
  int    OPOSTL12 3762-3765
  long   OPOWCP12 3766-3770
  long   OPOOPR12 3771-3775
  int    OPOOPU12 3776-3778
  int    OPOOSR12 3779-3782
  long   OPOPTR12 3783-3787
  long   OPOOTH12 3788-3792
  long   OPPEXP12 3793-3797
  long   OPPTCH12 3798-3802
  int    OPPSLF12 3803-3806
  int    OPPMCR12 3807-3810
  int    OPPMCD12 3811-3814
  long   OPPPRV12 3815-3819
  int    OPPVA12 3820-3823
  int    OPPTRI12 3824-3826
  byte   OPPOFD12 3827-3827
  int    OPPSTL12 3828-3830
  int    OPPWCP12 3831-3834
  int    OPPOPR12 3835-3838
  int    OPPOPU12 3839-3841
  int    OPPOSR12 3842-3844
  long   OPPPTR12 3845-3849
  int    OPPOTH12 3850-3853
  byte   AMCHIR12 3854-3855
  long   AMCTCH12 3856-3860
  long   AMCEXP12 3861-3865
  int    AMCSLF12 3866-3869
  int    AMCMCR12 3870-3873
  int    AMCMCD12 3874-3877
  long   AMCPRV12 3878-3882
  int    AMCVA12 3883-3885
  int    AMCTRI12 3886-3889
  byte   AMCOFD12 3890-3890
  int    AMCSTL12 3891-3893
  int    AMCWCP12 3894-3897
  int    AMCOPR12 3898-3901
  byte   AMCOPU12 3902-3902
  long   AMCOSR12 3903-3907
  long   AMCPTR12 3908-3912
  long   AMCOTH12 3913-3917
  int    AMNURS12 3918-3920
  long   AMNTCH12 3921-3926
  long   AMNEXP12 3927-3931
  int    AMNSLF12 3932-3935
  long   AMNMCR12 3936-3940
  long   AMNMCD12 3941-3945
  long   AMNPRV12 3946-3950
  long   AMNVA12 3951-3955
  int    AMNTRI12 3956-3959
  int    AMNOFD12 3960-3963
  int    AMNSTL12 3964-3967
  int    AMNWCP12 3968-3971
  long   AMNOPR12 3972-3976
  int    AMNOPU12 3977-3980
  long   AMNOSR12 3981-3985
  long   AMNPTR12 3986-3990
  long   AMNOTH12 3991-3995
  byte   AMOPTO12 3996-3997
  int    AMETCH12 3998-4001
  int    AMEEXP12 4002-4005
  int    AMESLF12 4006-4009
  int    AMEMCR12 4010-4013
  int    AMEMCD12 4014-4017
  int    AMEPRV12 4018-4021
  int    AMEVA12 4022-4024
  int    AMETRI12 4025-4027
  int    AMEOFD12 4028-4030
  int    AMESTL12 4031-4033
  byte   AMEWCP12 4034-4034
  int    AMEOPR12 4035-4038
  byte   AMEOPU12 4039-4040
  int    AMEOSR12 4041-4043
  int    AMEPTR12 4044-4047
  int    AMEOTH12 4048-4051
  byte   AMASST12 4052-4053
  long   AMATCH12 4054-4058
  int    AMAEXP12 4059-4062
  int    AMASLF12 4063-4066
  int    AMAMCR12 4067-4070
  int    AMAMCD12 4071-4074
  int    AMAPRV12 4075-4078
  int    AMAVA12 4079-4082
  int    AMATRI12 4083-4086
  int    AMAOFD12 4087-4089
  int    AMASTL12 4090-4092
  int    AMAWCP12 4093-4096
  int    AMAOPR12 4097-4099
  int    AMAOPU12 4100-4102
  int    AMAOSR12 4103-4105
  int    AMAPTR12 4106-4109
  int    AMAOTH12 4110-4112
  int    AMTHER12 4113-4115
  long   AMTTCH12 4116-4121
  long   AMTEXP12 4122-4126
  int    AMTSLF12 4127-4130
  long   AMTMCR12 4131-4135
  long   AMTMCD12 4136-4140
  long   AMTPRV12 4141-4145
  long   AMTVA12 4146-4150
  long   AMTTRI12 4151-4155
  int    AMTOFD12 4156-4158
  int    AMTSTL12 4159-4162
  long   AMTWCP12 4163-4167
  long   AMTOPR12 4168-4172
  int    AMTOPU12 4173-4175
  long   AMTOSR12 4176-4180
  long   AMTPTR12 4181-4185
  long   AMTOTH12 4186-4190
  byte   AMTOTC12 4191-4192
  byte   AMDRC12 4193-4194
  byte   ERTOT12 4195-4196
  long   ERTTCH12 4197-4202
  long   ERTEXP12 4203-4207
  long   ERTSLF12 4208-4212
  long   ERTMCR12 4213-4217
  long   ERTMCD12 4218-4222
  long   ERTPRV12 4223-4227
  long   ERTVA12 4228-4232
  int    ERTTRI12 4233-4236
  int    ERTOFD12 4237-4240
  int    ERTSTL12 4241-4244
  long   ERTWCP12 4245-4249
  int    ERTOPR12 4250-4253
  long   ERTOPU12 4254-4258
  long   ERTOSR12 4259-4263
  long   ERTPTR12 4264-4268
  long   ERTOTH12 4269-4273
  long   ERFTCH12 4274-4279
  long   ERFEXP12 4280-4284
  long   ERFSLF12 4285-4289
  long   ERFMCR12 4290-4294
  long   ERFMCD12 4295-4299
  long   ERFPRV12 4300-4304
  long   ERFVA12 4305-4309
  int    ERFTRI12 4310-4313
  int    ERFOFD12 4314-4317
  int    ERFSTL12 4318-4321
  long   ERFWCP12 4322-4326
  int    ERFOPR12 4327-4330
  long   ERFOPU12 4331-4335
  long   ERFOSR12 4336-4340
  long   ERFPTR12 4341-4345
  long   ERFOTH12 4346-4350
  long   ERDEXP12 4351-4355
  long   ERDTCH12 4356-4360
  int    ERDSLF12 4361-4364
  int    ERDMCR12 4365-4368
  int    ERDMCD12 4369-4372
  int    ERDPRV12 4373-4376
  int    ERDVA12 4377-4379
  int    ERDTRI12 4380-4383
  byte   ERDOFD12 4384-4384
  int    ERDSTL12 4385-4388
  int    ERDWCP12 4389-4392
  int    ERDOPR12 4393-4396
  int    ERDOPU12 4397-4400
  int    ERDOSR12 4401-4403
  int    ERDPTR12 4404-4407
  int    ERDOTH12 4408-4411
  byte   IPZERO12 4412-4412
  long   ZIFTCH12 4413-4417
  long   ZIFEXP12 4418-4422
  long   ZIFSLF12 4423-4427
  long   ZIFMCR12 4428-4432
  int    ZIFMCD12 4433-4436
  long   ZIFPRV12 4437-4441
  int    ZIFVA12 4442-4445
  int    ZIFTRI12 4446-4449
  byte   ZIFOFD12 4450-4450
  byte   ZIFSTL12 4451-4451
  byte   ZIFWCP12 4452-4452
  byte   ZIFOPR12 4453-4454
  byte   ZIFOPU12 4455-4455
  int    ZIFOSR12 4456-4459
  long   ZIFPTR12 4460-4464
  int    ZIFOTH12 4465-4468
  int    ZIDEXP12 4469-4472
  long   ZIDTCH12 4473-4477
  int    ZIDSLF12 4478-4481
  int    ZIDMCR12 4482-4485
  int    ZIDMCD12 4486-4489
  int    ZIDPRV12 4490-4493
  byte   ZIDVA12 4494-4494
  byte   ZIDTRI12 4495-4495
  byte   ZIDOFD12 4496-4496
  byte   ZIDSTL12 4497-4497
  byte   ZIDWCP12 4498-4498
  int    ZIDOPR12 4499-4501
  byte   ZIDOPU12 4502-4502
  byte   ZIDOSR12 4503-4503
  int    ZIDPTR12 4504-4507
  int    ZIDOTH12 4508-4510
  byte   IPDIS12 4511-4511
  long   IPTEXP12 4512-4517
  long   IPTTCH12 4518-4524
  long   IPTSLF12 4525-4530
  long   IPTMCR12 4531-4536
  long   IPTMCD12 4537-4542
  long   IPTPRV12 4543-4548
  long   IPTVA12 4549-4554
  long   IPTTRI12 4555-4559
  int    IPTOFD12 4560-4563
  long   IPTSTL12 4564-4568
  long   IPTWCP12 4569-4573
  long   IPTOPR12 4574-4578
  long   IPTOPU12 4579-4583
  long   IPTOSR12 4584-4588
  long   IPTPTR12 4589-4594
  long   IPTOTH12 4595-4599
  long   IPFEXP12 4600-4605
  long   IPFTCH12 4606-4612
  long   IPFSLF12 4613-4618
  long   IPFMCR12 4619-4624
  long   IPFMCD12 4625-4630
  long   IPFPRV12 4631-4636
  long   IPFVA12 4637-4642
  long   IPFTRI12 4643-4647
  int    IPFOFD12 4648-4651
  long   IPFSTL12 4652-4656
  long   IPFWCP12 4657-4661
  long   IPFOPR12 4662-4666
  long   IPFOPU12 4667-4671
  long   IPFOSR12 4672-4676
  long   IPFPTR12 4677-4682
  long   IPFOTH12 4683-4687
  long   IPDEXP12 4688-4692
  long   IPDTCH12 4693-4698
  long   IPDSLF12 4699-4703
  long   IPDMCR12 4704-4708
  long   IPDMCD12 4709-4713
  long   IPDPRV12 4714-4718
  int    IPDVA12 4719-4722
  int    IPDTRI12 4723-4726
  byte   IPDOFD12 4727-4727
  long   IPDSTL12 4728-4732
  int    IPDWCP12 4733-4736
  int    IPDOPR12 4737-4740
  int    IPDOPU12 4741-4744
  int    IPDOSR12 4745-4748
  long   IPDPTR12 4749-4753
  long   IPDOTH12 4754-4758
  int    IPNGTD12 4759-4761
  byte   DVTOT12 4762-4763
  long   DVTTCH12 4764-4768
  long   DVTEXP12 4769-4773
  long   DVTSLF12 4774-4778
  int    DVTMCR12 4779-4782
  int    DVTMCD12 4783-4786
  long   DVTPRV12 4787-4791
  int    DVTVA12 4792-4795
  int    DVTTRI12 4796-4799
  int    DVTOFD12 4800-4803
  int    DVTSTL12 4804-4807
  byte   DVTWCP12 4808-4808
  long   DVTOPR12 4809-4813
  int    DVTOPU12 4814-4817
  int    DVTOSR12 4818-4821
  long   DVTPTR12 4822-4826
  long   DVTOTH12 4827-4831
  byte   DVGEN12 4832-4833
  long   DVGTCH12 4834-4838
  long   DVGEXP12 4839-4843
  long   DVGSLF12 4844-4848
  int    DVGMCR12 4849-4852
  int    DVGMCD12 4853-4856
  long   DVGPRV12 4857-4861
  int    DVGVA12 4862-4865
  int    DVGTRI12 4866-4869
  int    DVGOFD12 4870-4873
  int    DVGSTL12 4874-4877
  byte   DVGWCP12 4878-4878
  int    DVGOPR12 4879-4882
  int    DVGOPU12 4883-4886
  int    DVGOSR12 4887-4890
  long   DVGPTR12 4891-4895
  int    DVGOTH12 4896-4899
  byte   DVORTH12 4900-4901
  long   DVOTCH12 4902-4906
  long   DVOEXP12 4907-4911
  long   DVOSLF12 4912-4916
  byte   DVOMCR12 4917-4917
  int    DVOMCD12 4918-4921
  long   DVOPRV12 4922-4926
  int    DVOVA12 4927-4930
  int    DVOTRI12 4931-4934
  int    DVOOFD12 4935-4938
  int    DVOSTL12 4939-4942
  byte   DVOWCP12 4943-4943
  long   DVOOPR12 4944-4948
  int    DVOOPU12 4949-4952
  byte   DVOOSR12 4953-4953
  long   DVOPTR12 4954-4958
  long   DVOOTH12 4959-4963
  int    HHTOTD12 4964-4966
  int    HHAGD12 4967-4969
  long   HHATCH12 4970-4975
  long   HHAEXP12 4976-4981
  long   HHASLF12 4982-4986
  long   HHAMCR12 4987-4991
  long   HHAMCD12 4992-4997
  long   HHAPRV12 4998-5002
  long   HHAVA12 5003-5007
  byte   HHATRI12 5008-5008
  byte   HHAOFD12 5009-5009
  long   HHASTL12 5010-5014
  byte   HHAWCP12 5015-5015
  int    HHAOPR12 5016-5019
  int    HHAOPU12 5020-5022
  int    HHAOSR12 5023-5026
  long   HHAPTR12 5027-5031
  long   HHAOTH12 5032-5036
  int    HHINDD12 5037-5039
  long   HHNTCH12 5040-5045
  long   HHNEXP12 5046-5051
  long   HHNSLF12 5052-5057
  long   HHNMCD12 5058-5062
  int    HHNMCR12 5063-5066
  int    HHNPRV12 5067-5070
  int    HHNVA12 5071-5073
  byte   HHNTRI12 5074-5074
  byte   HHNOFD12 5075-5075
  int    HHNSTL12 5076-5079
  byte   HHNWCP12 5080-5080
  byte   HHNOPR12 5081-5081
  byte   HHNOPU12 5082-5082
  byte   HHNOSR12 5083-5083
  int    HHNPTR12 5084-5087
  int    HHNOTH12 5088-5091
  int    HHINFD12 5092-5094
  int    VISEXP12 5095-5098
  int    VISTCH12 5099-5102
  int    VISSLF12 5103-5106
  int    VISMCR12 5107-5110
  int    VISMCD12 5111-5114
  int    VISPRV12 5115-5118
  int    VISVA12 5119-5121
  int    VISTRI12 5122-5124
  int    VISOFD12 5125-5127
  int    VISSTL12 5128-5131
  int    VISWCP12 5132-5134
  int    VISOPR12 5135-5137
  int    VISOPU12 5138-5140
  int    VISOSR12 5141-5143
  int    VISPTR12 5144-5147
  int    VISOTH12 5148-5151
  long   OTHTCH12 5152-5156
  long   OTHEXP12 5157-5161
  long   OTHSLF12 5162-5166
  long   OTHMCR12 5167-5171
  long   OTHMCD12 5172-5176
  long   OTHPRV12 5177-5181
  int    OTHVA12 5182-5185
  int    OTHTRI12 5186-5189
  byte   OTHOFD12 5190-5190
  long   OTHSTL12 5191-5195
  int    OTHWCP12 5196-5199
  int    OTHOPR12 5200-5203
  int    OTHOPU12 5204-5206
  int    OTHOSR12 5207-5210
  long   OTHPTR12 5211-5215
  long   OTHOTH12 5216-5220
  int    RXTOT12 5221-5223
  long   RXEXP12 5224-5229
  long   RXSLF12 5230-5234
  long   RXMCR12 5235-5240
  long   RXMCD12 5241-5246
  long   RXPRV12 5247-5251
  long   RXVA12 5252-5256
  long   RXTRI12 5257-5261
  int    RXOFD12 5262-5265
  long   RXSTL12 5266-5271
  long   RXWCP12 5272-5276
  long   RXOPR12 5277-5281
  long   RXOPU12 5282-5286
  long   RXOSR12 5287-5291
  long   RXPTR12 5292-5296
  long   RXOTH12 5297-5302
  double PERWT12F 5303-5314
  double FAMWT12F 5315-5326
  double FAMWT12C 5327-5338
  double SAQWT12F 5339-5350
  double DIABW12F 5351-5362
  int    VARSTR 5363-5366
  byte   VARPSU 5367-5367
using H155.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID12 "FAMILY ID (STUDENT MERGED IN) - 12/31/12";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR12 "RU LETTER AS OF 12/31/12";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE12 "RU SIZE AS OF 12/31/12";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS12 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/12";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE12 "RU SIZE INCLUDING STUDENT AS OF 12/31/12";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION12 "CENSUS REGION AS OF 12/31/12";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA12 "MSA AS OF 12/31/12";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS12 "REFERENCE PERSON AS OF 12/31/12";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP12 "1ST RESPONDENT INDICATOR AS OF 12/31/12";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY12 "WAS RESPONDENT A PROXY AS OF 12/31/12";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD12 "2012 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM12 "2012 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY12 "2012 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP12 "INSCOPE - R5/3 START THROUGH 12/31/12";
label variable INSC1231 "INSCOPE STATUS ON 12/31/12";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2012";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND12 "ELIGIBILITY STATUS AS OF 12/31/12";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE12X "AGE AS OF 12/31/12 (EDITED/IMPUTED)";
label variable AGELAST "PERSON S AGE LAST TIME ELIGIBLE";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEVER "RACE QUESTION VERSION ASKED";
label variable RACEV1X "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY12X "MARITAL STATUS-12/31/12 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID12 "SPOUSE ID - 12/31/12";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN12 "MARITAL STATUS W/SPOUSE PRESENT-12/31/12";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable EDUYRDEG "YEAR OF EDUCATION OR HIGHEST DEGREE";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable EDRECODE "EDUCATION RECODE (EDITED)";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU12X "STUDENT STATUS IF AGES 17-23 - 12/31/12";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC53 "HONORABLY DISCHARGED FROM MILITARY";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL12X "RELATION TO REF PERS-12/31/12 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable HIBPAGED "AGE OF DIAGNOSIS-HIGH BLOOD PRESSURE";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable CHDAGED "AGE OF DIAGNOSIS-CORONARY HEART DISEASE";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable ANGIAGED "AGE OF DIAGNOSIS-ANGINA";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable MIAGED "AGE OF DIAGNOSIS-HEART ATTACK(MI)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable OHRTAGED "AGE OF DIAGNOSIS-OTHER HEART DISEASE";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable STRKAGED "AGE OF DIAGNOSIS-STROKE";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable EMPHAGED "AGE OF DIAGNOSIS-EMPHYSEMA";
label variable CHBRON31 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R3/1";
label variable CHBRON53 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R5/3";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHOLAGED "AGE OF DIAGNOSIS-HIGH CHOLESTEROL";
label variable CANCERDX "CANCER DIAGNOSIS (>17)";
label variable CABLADDR "CANCER DIAGNOSED - BLADDER (>17)";
label variable BLDRAGED "AGE OF DIAGNOSIS-BLADDER CANCER";
label variable BLDRREMS "BLADDER CANCER IN REMISSION";
label variable CABRAIN "CANCER DIAGNOSED - BRAIN (>17)";
label variable BRAIAGED "AGE OF DIAGNOSIS-BRAIN CANCER";
label variable BRAIREMS "BRAIN CANCER IN REMISSION";
label variable CABREAST "CANCER DIAGNOSED - BREAST (>17)";
label variable BRSTAGED "AGE OF DIAGNOSIS-BREAST CANCER";
label variable BRSTREMS "BREAST CANCER IN REMISSION";
label variable CACERVIX "CANCER DIAGNOSED - CERVIX (>17)";
label variable CERVAGED "AGE OF DIAGNOSIS-CERVICAL CANCER";
label variable CERVREMS "CERVICAL CANCER IN REMISSION";
label variable CACOLON "CANCER DIAGNOSED - COLON (>17)";
label variable COLOAGED "AGE OF DIAGNOSIS-COLON CANCER";
label variable COLOREMS "COLON CANCER IN REMISSION";
label variable CALEUKEM "CANCER DIAGNOSED - LEUKEMIA (>17)";
label variable LEUKAGED "AGE OF DIAGNOSIS-LEUKEMIA";
label variable LEUKREMS "LEUKEMIA IN REMISSION";
label variable CALUNG "CANCER DIAGNOSED - LUNG (>17)";
label variable LUNGAGED "AGE OF DIAGNOSIS-LUNG CANCER";
label variable LUNGREMS "LUNG CANCER IN REMISSION";
label variable CALYMPH "CANCER DIAGNOSED - LYMPHOMA (>17)";
label variable LYMPAGED "AGE OF DIAGNOSIS-LYMPHOMA";
label variable LYMPREMS "LYMPHOMA IN REMISSION";
label variable CAMELANO "CANCER DIAGNOSED - MELANOMA (>17)";
label variable MELAAGED "AGE OF DIAGNOSIS-MELANOMA";
label variable MELAREMS "MELANOMA IN REMISSION";
label variable CAOTHER "CANCER DIAGNOSED - OTHER (>17)";
label variable OTHRAGED "AGE OF DIAGNOSIS-OTHER CANCER";
label variable OTHRREMS "OTHER CANCER IN REMISSION";
label variable CAPROSTA "CANCER DIAGNOSED - PROSTATE (>17)";
label variable PRSTAGED "AGE OF DIAGNOSIS-PROSTATE CANCER";
label variable PRSTREMS "PROSTATE CANCER IN REMISSION";
label variable CASKINNM "CANCER DIAGNOSED - SKIN-NONMELANO (>17)";
label variable SKNMAGED "AGE OF DIAGNOSIS-SKIN-NONMELANOMA CANCER";
label variable SKNMREMS "SKIN-NONMELANOMA CANCER IN REMISSION";
label variable CASKINDK "CANCER DIAGNOSED-SKIN-UNKNOWN TYPE (>17)";
label variable SKDKAGED "AGE OF DIAGNOSIS-SKIN-UNKNWN TYPE CANCER";
label variable SKDKREMS "SKIN-UNKNOWN TYPE CANCER IN REMISSION";
label variable CATHROAT "CANCER DIAGNOSED - THROAT (>17)";
label variable THRTAGED "AGE OF DIAGNOSIS-THROAT CANCER";
label variable THRTREMS "THROAT CANCER IN REMISSION";
label variable CATHYROD "CANCER DIAGNOSED - THYROID (>17)";
label variable THYRAGED "AGE OF DIAGNOSIS-THYROID CANCER";
label variable THYRREMS "THYROID CANCER IN REMISSION";
label variable DIABDX "DIABETES DIAGNOSIS (>17)";
label variable DIABAGED "AGE OF DIAGNOSIS-DIABETES";
label variable JTPAIN31 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ARTHTYPE "TYPE OF ARTHRITIS DIAGNOSED (>17)";
label variable ARTHAGED "AGE OF DIAGNOSIS-ARTHRITIS";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASTHAGED "AGE OF DIAGNOSIS-ASTHMA";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA-RD3/1";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS - RD3/1";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASTHEP31 "WHEN WAS LAST EPISODE OF ASTHMA - RD 3/1";
label variable ASTHEP53 "WHEN WAS LAST EPISODE OF ASTHMA - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable ADHDADDX "ADHDADD DIAGNOSIS (5-17)";
label variable ADHDAGED "AGE OF DIAGNOSIS-ADHD/ADD";
label variable PREGNT31 "PREGNANT DURING REF PERIOD - RD 3/1";
label variable PREGNT42 "PREGNANT DURING REF PERIOD - RD 4/2";
label variable PREGNT53 "PREGNANT DURING REF PERIOD - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable IADL3M31 "IADL HELP 3+ MONTHS - RD 3/1";
label variable IADL3M42 "IADL HELP 3+ MONTHS - RD 4/2";
label variable IADL3M53 "IADL HELP 3+ MONTHS - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable ADL3MO31 "ADL HELP 3+ MONTHS - RD 3/1";
label variable ADL3MO42 "ADL HELP 3+ MONTHS - RD 4/2";
label variable ADL3MO53 "ADL HELP 3+ MONTHS - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable WLK3MO31 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 3/1";
label variable WLK3MO53 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM12 "ANY LIMITATION IN P16R3,4,5/P17R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHENEC42 "CAHPS:12MOS:EASY GET NEC CARE (0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHEYRE42 "CAHPS:12MOS:ESY W/RFR TO SPEC(0-17)-R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU VACINATION (>17)-RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable BSTST53 "MST RCNT BLD STOOL TST HME KIT(>39)-R5/3";
label variable BSTSRE53 "RSN HAVE BLD STOOL TST (>39)-R5/3";
label variable CLNTST53 "MOST RECENT COLONOSCOPY (>39) - R5/3";
label variable CLNTRE53 "RSN HAVE COLONOSCOPY (>39)-R5/3";
label variable SGMTST53 "MOST RECENT SIGMOIDOSCOPY (>39) - R5/3";
label variable SGMTRE53 "RSN HAVE SIGMOIDOSCOPY (>39)-R5/3";
label variable PHYEXE53 "MOD/VIG PHYS EXEC 5X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADEGMC42 "SAQ 12MOS: EASY GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADINST42 "SAQ 12 MOS: DR GAVE SPCIFC INSTRCTNS";
label variable ADEZUN42 "SAQ 12 MOS: DR GIVEN INSTR. EZ UNDRSTD";
label variable ADTLHW42 "SAQ 12 MOS: DR ASKED R DESC HOW FOLLOW";
label variable ADFFRM42 "SAQ 12 MOS: HAD TO FILL OUT/SIGN FORMS";
label variable ADFHLP42 "SAQ 12 MOS: OFFRD HELP FILLING OUT FORMS";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADSPRF42 "SAQ 12MOS: HOW ESY GETTING SPEC REFERRAL";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPD42 "SAQ: DATE COMPLETED - DAY";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C IN 2012";
label variable DSFT1353 "DCS: HAD FEET CHECKED DURING 2013";
label variable DSFT1253 "DCS: HAD FEET CHECKED DURING 2012";
label variable DSFT1153 "DCS: HAD FEET CHECKED DURING 2011";
label variable DSFB1153 "DCS: HAD FEET CHECKED BEFORE 2011";
label variable DSFTNV53 "DCS: NEVER HAD FEET CHECKED";
label variable DSEY1353 "DCS: DILATED EYE EXAM IN 2013";
label variable DSEY1253 "DCS: DILATED EYE EXAM IN 2012";
label variable DSEY1153 "DCS: DILATED EYE EXAM IN 2011";
label variable DSEB1153 "DCS: DILATED EYE EXAM BEFORE 2011";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSCH1353 "DCS: BLOOD CHOLESTEROL CHECKED IN 2013";
label variable DSCH1253 "DCS: BLOOD CHOLESTEROL CHECKED IN 2012";
label variable DSCH1153 "DCS: BLOOD CHOLESTEROL CHECKED IN 2011";
label variable DSCB1153 "DCS: BLOOD CHOLESTEROL CHECKED BEF 2011";
label variable DSCHNV53 "DCS: NEVER HAD BLOOD CHOLESTEROL CHECKED";
label variable DSFL1353 "DCS: GOT FLU VACCINATION IN 2013";
label variable DSFL1253 "DCS: GOT FLU VACCINATION IN 2012";
label variable DSFL1153 "DCS: GOT FLU VACCINATION IN 2011";
label variable DSVB1153 "DCS: GOT FLU VACCINATION BEFORE 2011";
label variable DSFLNV53 "DCS: NEVER GOT FLU VACCINATION";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSCPCP53 "DCS: LEARNED CARE FROM PRIMARY CARE PROV";
label variable DSCNPC53 "DCS: LEARNED CARE FROM OTHER PROVIDER";
label variable DSCPHN53 "DCS: LEARN CARE FROM PHONE CALL W/PROV";
label variable DSCINT53 "DCS: LEARNED CARE FROM READING INTERNET";
label variable DSCGRP53 "DCS: LEARNED CARE BY TAKING GROUP CLASS";
label variable DSCONF53 "DCS: CONFIDENT TAKING CARE OF DIABETES";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WORK DAY TO CARE FOR OTH (RD31)";
label variable OTHDYS42 "MISS ANY WORK DAY TO CARE FOR OTH (RD42)";
label variable OTHDYS53 "MISS ANY WORK DAY TO CARE FOR OTH (RD53)";
label variable OTHNDD31 "# DAY MISSED WORK TO CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WORK TO CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WORK TO CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable LANGHM42 "AC01 LANGUAGE SPOKEN MOST IN HOME-R4/2";
label variable ENGCMF42 "AC02 WHOLE HH COMFRTBLE SPEAKNG ENG-R4/2";
label variable ENGSPK42 "AC02A NOT COMFRTBLE SPEAKNG ENGLISH-R4/2";
label variable USBORN42 "AC03 WAS PERSON BORN IN US-R4/2";
label variable USLIVE42 "AC04 # YRS PERSON LIVED IN US-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable NOHINS42 "AC08 OTH REAS NO USC:NO HLTH INSRNC-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable HEALTH42 "AC08 OTH REAS NO USC: HLTH RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC: DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable GOTOUS42 "AC12 HOW DOES PERS GET TO USC PROV-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable DFTOUS42 "AC14 HOW DIFFICULT IS IT GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable LANGPR42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDUNPR42 "AC35 PRB NOT GETTING NCSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable MDDLPR42 "AC39 PRB DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNUNPR42 "AC43 PRB UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable DNDLPR42 "AC47 PRB DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMUNPR42 "AC51 PRB UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable PMDLPR42 "AC55 PRB DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/12";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable YNOINS31 "WHY NOT ELIGIBLE HEALTH INS RD 3/1 CMJ";
label variable YNOINS42 "WHY NOT ELIGIBLE HEALTH INS RD 4/2 CMJ";
label variable YNOINS53 "WHY NOT ELIGIBLE HEALTH INS RD 5/3 CMJ";
label variable SSIDIS12 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC12 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR12 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL12 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT12 "PERSON S FILING STATUS";
label variable FILER12 "PRIMARY OR SECONDARY FILER";
label variable JTINRU12 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID12 "PID OF SECONDARY FILER";
label variable CLMDEP12 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT12 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU12 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD12 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM12 "TAX FORM PERSON WILL FILE";
label variable DEDUCT12 "ITEMIZE OR STANDARD DEDUCTION";
label variable TOTDED12 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP12 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT12 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST12 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN12 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL12 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP12X "PERSON S TOTAL INCOME";
label variable FAMINC12 "FAMILY S TOTAL INCOME";
label variable POVCAT12 "FAMILY INC AS % OF POVERTY LINE - CATEGO";
label variable POVLEV12 "FAMILY INC AS % OF POVERTY LINE - CONTIN";
label variable WAGEP12X "PERSON S WAGE INCOME";
label variable WAGIMP12 "WAGE IMPUTATION FLAG";
label variable BUSNP12X "PERSON S BUSINESS INCOME";
label variable BUSIMP12 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP12X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP12 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP12X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP12 "WORKERS  COMP IMPUTATION FLAG";
label variable INTRP12X "PERSON S INTEREST INCOME";
label variable INTIMP12 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP12X "PERSON S DIVIDEND INCOME";
label variable DIVIMP12 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP12X "PERSON S SALES INCOME";
label variable SALIMP12 "SALES INCOME IMPUTATION FLAG";
label variable PENSP12X "PERSON S PENSION INCOME";
label variable PENIMP12 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP12X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP12 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP12X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP12 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP12X "PERSON S VETERAN S INCOME";
label variable VETIMP12 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP12X "PERSON S IRA INCOME";
label variable IRAIMP12 "IRA INCOME IMPUTATION FLAG";
label variable REFDP12X "PERSON S REFUND INCOME";
label variable REFIMP12 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP12X "PERSON S ALIMONY INCOME";
label variable ALIIMP12 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP12X "PERSON S CHILD SUPPORT";
label variable CHLIMP12 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP12X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP12 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP12X "PERSON S SSI";
label variable SSIIMP12 "SSI IMPUTATION FLAG";
label variable PUBP12X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP12 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP12X "PERSON S OTHER INCOME";
label variable OTHIMP12 "OTHER INCOME IMPUTATION FLAG";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable TRIJA12X "COVERED BY TRICARE/CHAMPVA IN JAN12 (ED)";
label variable TRIFE12X "COVERED BY TRICARE/CHAMPVA IN FEB12 (ED)";
label variable TRIMA12X "COVERED BY TRICARE/CHAMPVA IN MAR12 (ED)";
label variable TRIAP12X "COVERED BY TRICARE/CHAMPVA IN APR12(ED)";
label variable TRIMY12X "COVERED BY TRICARE/CHAMPVA IN MAY12 (ED)";
label variable TRIJU12X "COVERED BY TRICARE/CHAMPVA IN JUN12 (ED)";
label variable TRIJL12X "COVERED BY TRICARE/CHAMPVA IN JUL12 (ED)";
label variable TRIAU12X "COVERED BY TRICARE/CHAMPVA IN AUG12 (ED)";
label variable TRISE12X "COVERED BY TRICARE/CHAMPVA IN SEP12 (ED)";
label variable TRIOC12X "COVERED BY TRICARE/CHAMPVA IN OCT12 (ED)";
label variable TRINO12X "COVERED BY TRICARE/CHAMPVA IN NOV12 (ED)";
label variable TRIDE12X "COVERED BY TRICARE/CHAMPVA IN DEC12 (ED)";
label variable MCRJA12 "COVERED BY MEDICARE IN JAN12";
label variable MCRFE12 "COVERED BY MEDICARE IN FEB12";
label variable MCRMA12 "COVERED BY MEDICARE IN MAR12";
label variable MCRAP12 "COVERED BY MEDICARE IN APR12";
label variable MCRMY12 "COVERED BY MEDICARE IN MAY12";
label variable MCRJU12 "COVERED BY MEDICARE IN JUN12";
label variable MCRJL12 "COVERED BY MEDICARE IN JUL12";
label variable MCRAU12 "COVERED BY MEDICARE IN AUG12";
label variable MCRSE12 "COVERED BY MEDICARE IN SEP12";
label variable MCROC12 "COVERED BY MEDICARE IN OCT12";
label variable MCRNO12 "COVERED BY MEDICARE IN NOV12";
label variable MCRDE12 "COVERED BY MEDICARE IN DEC12";
label variable MCRJA12X "COVERED BY MEDICARE IN JAN12 (ED)";
label variable MCRFE12X "COVERED BY MEDICARE IN FEB12 (ED)";
label variable MCRMA12X "COVERED BY MEDICARE IN MAR12 (ED)";
label variable MCRAP12X "COVERED BY MEDICARE IN APR12 (ED)";
label variable MCRMY12X "COVERED BY MEDICARE IN MAY12 (ED)";
label variable MCRJU12X "COVERED BY MEDICARE IN JUN12 (ED)";
label variable MCRJL12X "COVERED BY MEDICARE IN JUL12 (ED)";
label variable MCRAU12X "COVERED BY MEDICARE IN AUG12 (ED)";
label variable MCRSE12X "COVERED BY MEDICARE IN SEP12 (ED)";
label variable MCROC12X "COVERED BY MEDICARE IN OCT12 (ED)";
label variable MCRNO12X "COVERED BY MEDICARE IN NOV12 (ED)";
label variable MCRDE12X "COVERED BY MEDICARE IN DEC12 (ED)";
label variable MCDJA12 "COV BY MEDICAID OR SCHIP IN JAN12";
label variable MCDFE12 "COV BY MEDICAID OR SCHIP IN FEB12";
label variable MCDMA12 "COV BY MEDICAID OR SCHIP IN MAR12";
label variable MCDAP12 "COV BY MEDICAID OR SCHIP IN APR12";
label variable MCDMY12 "COV BY MEDICAID OR SCHIP IN MAY12";
label variable MCDJU12 "COV BY MEDICAID OR SCHIP IN JUN12";
label variable MCDJL12 "COV BY MEDICAID OR SCHIP IN JUL12";
label variable MCDAU12 "COV BY MEDICAID OR SCHIP IN AUG12";
label variable MCDSE12 "COV BY MEDICAID OR SCHIP IN SEP12";
label variable MCDOC12 "COV BY MEDICAID OR SCHIP IN OCT12";
label variable MCDNO12 "COV BY MEDICAID OR SCHIP IN NOV12";
label variable MCDDE12 "COV BY MEDICAID OR SCHIP IN DEC12";
label variable MCDJA12X "COV BY MEDICAID OR SCHIP IN JAN12 (ED)";
label variable MCDFE12X "COV BY MEDICAID OR SCHIP IN FEB12 (ED)";
label variable MCDMA12X "COV BY MEDICAID OR SCHIP IN MAR12 (ED)";
label variable MCDAP12X "COV BY MEDICAID OR SCHIP IN APR12 (ED)";
label variable MCDMY12X "COV BY MEDICAID OR SCHIP IN MAY12 (ED)";
label variable MCDJU12X "COV BY MEDICAID OR SCHIP IN JUN12 (ED)";
label variable MCDJL12X "COV BY MEDICAID OR SCHIP IN JUL12 (ED)";
label variable MCDAU12X "COV BY MEDICAID OR SCHIP IN AUG12 (ED)";
label variable MCDSE12X "COV BY MEDICAID OR SCHIP IN SEP12 (ED)";
label variable MCDOC12X "COV BY MEDICAID OR SCHIP IN OCT12 (ED)";
label variable MCDNO12X "COV BY MEDICAID OR SCHIP IN NOV12 (ED)";
label variable MCDDE12X "COV BY MEDICAID OR SCHIP IN DEC12 (ED)";
label variable OPAJA12 "COV BY OTHER PUBLIC A INS IN JAN12";
label variable OPAFE12 "COV BY OTHER PUBLIC A INS IN FEB12";
label variable OPAMA12 "COV BY OTHER PUBLIC A INS IN MAR12";
label variable OPAAP12 "COV BY OTHER PUBLIC A INS IN APR12";
label variable OPAMY12 "COV BY OTHER PUBLIC A INS IN MAY12";
label variable OPAJU12 "COV BY OTHER PUBLIC A INS IN JUN12";
label variable OPAJL12 "COV BY OTHER PUBLIC A INS IN JUL12";
label variable OPAAU12 "COV BY OTHER PUBLIC A INS IN AUG12";
label variable OPASE12 "COV BY OTHER PUBLIC A INS IN SEP12";
label variable OPAOC12 "COV BY OTHER PUBLIC A INS IN OCT12";
label variable OPANO12 "COV BY OTHER PUBLIC A INS IN NOV12";
label variable OPADE12 "COV BY OTHER PUBLIC A INS IN DEC12";
label variable OPBJA12 "COV BY OTHER PUBLIC B INS IN JAN12";
label variable OPBFE12 "COV BY OTHER PUBLIC B INS IN FEB12";
label variable OPBMA12 "COV BY OTHER PUBLIC B INS IN MAR12";
label variable OPBAP12 "COV BY OTHER PUBLIC B INS IN APR12";
label variable OPBMY12 "COV BY OTHER PUBLIC B INS IN MAY12";
label variable OPBJU12 "COV BY OTHER PUBLIC B INS IN JUN12";
label variable OPBJL12 "COV BY OTHER PUBLIC B INS IN JUL12";
label variable OPBAU12 "COV BY OTHER PUBLIC B INS IN AUG12";
label variable OPBSE12 "COV BY OTHER PUBLIC B INS IN SEP12";
label variable OPBOC12 "COV BY OTHER PUBLIC B INS IN OCT12";
label variable OPBNO12 "COV BY OTHER PUBLIC B INS IN NOV12";
label variable OPBDE12 "COV BY OTHER PUBLIC B INS IN DEC12";
label variable STAJA12 "COVERED BY OTHER STATE PROG IN JAN12";
label variable STAFE12 "COVERED BY OTHER STATE PROG IN FEB12";
label variable STAMA12 "COVERED BY OTHER STATE PROG IN MAR12";
label variable STAAP12 "COVERED BY OTHER STATE PROG IN APR12";
label variable STAMY12 "COVERED BY OTHER STATE PROG IN MAY12";
label variable STAJU12 "COVERED BY OTHER STATE PROG IN JUN12";
label variable STAJL12 "COVERED BY OTHER STATE PROG IN JUL12";
label variable STAAU12 "COVERED BY OTHER STATE PROG IN AUG12";
label variable STASE12 "COVERED BY OTHER STATE PROG IN SEP12";
label variable STAOC12 "COVERED BY OTHER STATE PROG IN OCT12";
label variable STANO12 "COVERED BY OTHER STATE PROG IN NOV12";
label variable STADE12 "COVERED BY OTHER STATE PROG IN DEC12";
label variable PUBJA12X "COVR BY ANY PUBLIC INS IN JAN12 (ED)";
label variable PUBFE12X "COVR BY ANY PUBLIC INS IN FEB12 (ED)";
label variable PUBMA12X "COVR BY ANY PUBLIC INS IN MAR12 (ED)";
label variable PUBAP12X "COVR BY ANY PUBLIC INS IN APR12 (ED)";
label variable PUBMY12X "COVR BY ANY PUBLIC INS IN MAY12 (ED)";
label variable PUBJU12X "COVR BY ANY PUBLIC INS IN JUN12 (ED)";
label variable PUBJL12X "COVR BY ANY PUBLIC INS IN JUL12 (ED)";
label variable PUBAU12X "COVR BY ANY PUBLIC INS IN AUG12 (ED)";
label variable PUBSE12X "COVR BY ANY PUBLIC INS IN SEP12 (ED)";
label variable PUBOC12X "COVR BY ANY PUBLIC INS IN OCT12 (ED)";
label variable PUBNO12X "COVR BY ANY PUBLIC INS IN NOV12 (ED)";
label variable PUBDE12X "COVR BY ANY PUBLIC INS IN DEC12 (ED)";
label variable PEGJA12 "COVERED BY EMPL UNION INS IN JAN12";
label variable PEGFE12 "COVERED BY EMPL UNION INS IN FEB12";
label variable PEGMA12 "COVERED BY EMPL UNION INS IN MAR12";
label variable PEGAP12 "COVERED BY EMPL UNION INS IN APR12";
label variable PEGMY12 "COVERED BY EMPL UNION INS IN MAY12";
label variable PEGJU12 "COVERED BY EMPL UNION INS IN JUN12";
label variable PEGJL12 "COVERED BY EMPL UNION INS IN JUL12";
label variable PEGAU12 "COVERED BY EMPL UNION INS IN AUG12";
label variable PEGSE12 "COVERED BY EMPL UNION INS IN SEP12";
label variable PEGOC12 "COVERED BY EMPL UNION INS IN OCT12";
label variable PEGNO12 "COVERED BY EMPL UNION INS IN NOV12";
label variable PEGDE12 "COVERED BY EMPL UNION INS IN DEC12";
label variable PDKJA12 "COVR BY PRIV INS (SOURCE UNKNWN) JAN12";
label variable PDKFE12 "COVR BY PRIV INS (SOURCE UNKNWN) FEB12";
label variable PDKMA12 "COVR BY PRIV INS (SOURCE UNKNWN) MAR12";
label variable PDKAP12 "COVR BY PRIV INS (SOURCE UNKNWN) APR12";
label variable PDKMY12 "COVR BY PRIV INS (SOURCE UNKNWN) MAY12";
label variable PDKJU12 "COVR BY PRIV INS (SOURCE UNKNWN) JUN12";
label variable PDKJL12 "COVR BY PRIV INS (SOURCE UNKNWN) JUL12";
label variable PDKAU12 "COVR BY PRIV INS (SOURCE UNKNWN) AUG12";
label variable PDKSE12 "COVR BY PRIV INS (SOURCE UNKNWN) SEP12";
label variable PDKOC12 "COVR BY PRIV INS (SOURCE UNKNWN) OCT12";
label variable PDKNO12 "COVR BY PRIV INS (SOURCE UNKNWN) NOV12";
label variable PDKDE12 "COVR BY PRIV INS (SOURCE UNKNWN) DEC12";
label variable PNGJA12 "COVERED BY NONGROUP INS IN JAN12";
label variable PNGFE12 "COVERED BY NONGROUP INS IN FEB12";
label variable PNGMA12 "COVERED BY NONGROUP INS IN MAR12";
label variable PNGAP12 "COVERED BY NONGROUP INS IN APR12";
label variable PNGMY12 "COVERED BY NONGROUP INS IN MAY12";
label variable PNGJU12 "COVERED BY NONGROUP INS IN JUN12";
label variable PNGJL12 "COVERED BY NONGROUP INS IN JUL12";
label variable PNGAU12 "COVERED BY NONGROUP INS IN AUG12";
label variable PNGSE12 "COVERED BY NONGROUP INS IN SEP12";
label variable PNGOC12 "COVERED BY NONGROUP INS IN OCT12";
label variable PNGNO12 "COVERED BY NONGROUP INS IN NOV12";
label variable PNGDE12 "COVERED BY NONGROUP INS IN DEC12";
label variable POGJA12 "COVERED BY OTHER GROUP INS IN JAN12";
label variable POGFE12 "COVERED BY OTHER GROUP INS IN FEB12";
label variable POGMA12 "COVERED BY OTHER GROUP INS IN MAR12";
label variable POGAP12 "COVERED BY OTHER GROUP INS IN APR12";
label variable POGMY12 "COVERED BY OTHER GROUP INS IN MAY12";
label variable POGJU12 "COVERED BY OTHER GROUP INS IN JUN12";
label variable POGJL12 "COVERED BY OTHER GROUP INS IN JUL12";
label variable POGAU12 "COVERED BY OTHER GROUP INS IN AUG12";
label variable POGSE12 "COVERED BY OTHER GROUP INS IN SEP12";
label variable POGOC12 "COVERED BY OTHER GROUP INS IN OCT12";
label variable POGNO12 "COVERED BY OTHER GROUP INS IN NOV12";
label variable POGDE12 "COVERED BY OTHER GROUP INS IN DEC12";
label variable PRSJA12 "COVERED BY SELF-EMP-1 INS IN JAN12";
label variable PRSFE12 "COVERED BY SELF-EMP-1 INS IN FEB12";
label variable PRSMA12 "COVERED BY SELF-EMP-1 INS IN MAR12";
label variable PRSAP12 "COVERED BY SELF-EMP-1 INS IN APR12";
label variable PRSMY12 "COVERED BY SELF-EMP-1 INS IN MAY12";
label variable PRSJU12 "COVERED BY SELF-EMP-1 INS IN JUN12";
label variable PRSJL12 "COVERED BY SELF-EMP-1 INS IN JUL12";
label variable PRSAU12 "COVERED BY SELF-EMP-1 INS IN AUG12";
label variable PRSSE12 "COVERED BY SELF-EMP-1 INS IN SEP12";
label variable PRSOC12 "COVERED BY SELF-EMP-1 INS IN OCT12";
label variable PRSNO12 "COVERED BY SELF-EMP-1 INS IN NOV12";
label variable PRSDE12 "COVERED BY SELF-EMP-1 INS IN DEC12";
label variable POUJA12 "COVERED BY HOLDER OUTSIDE OF RU IN JAN12";
label variable POUFE12 "COVERED BY HOLDER OUTSIDE OF RU IN FEB12";
label variable POUMA12 "COVERED BY HOLDER OUTSIDE OF RU IN MAR12";
label variable POUAP12 "COVERED BY HOLDER OUTSIDE OF RU IN APR12";
label variable POUMY12 "COVERED BY HOLDER OUTSIDE OF RU IN MAY12";
label variable POUJU12 "COVERED BY HOLDER OUTSIDE OF RU IN JUN12";
label variable POUJL12 "COVERED BY HOLDER OUTSIDE OF RU IN JUL12";
label variable POUAU12 "COVERED BY HOLDER OUTSIDE OF RU IN AUG12";
label variable POUSE12 "COVERED BY HOLDER OUTSIDE OF RU IN SEP12";
label variable POUOC12 "COVERED BY HOLDER OUTSIDE OF RU IN OCT12";
label variable POUNO12 "COVERED BY HOLDER OUTSIDE OF RU IN NOV12";
label variable POUDE12 "COVERED BY HOLDER OUTSIDE OF RU IN DEC12";
label variable PRIJA12 "COVERED BY PRIVATE INS IN JAN12";
label variable PRIFE12 "COVERED BY PRIVATE INS IN FEB12";
label variable PRIMA12 "COVERED BY PRIVATE INS IN MAR12";
label variable PRIAP12 "COVERED BY PRIVATE INS IN APR12";
label variable PRIMY12 "COVERED BY PRIVATE INS IN MAY12";
label variable PRIJU12 "COVERED BY PRIVATE INS IN JUN12";
label variable PRIJL12 "COVERED BY PRIVATE INS IN JUL12";
label variable PRIAU12 "COVERED BY PRIVATE INS IN AUG12";
label variable PRISE12 "COVERED BY PRIVATE INS IN SEP12";
label variable PRIOC12 "COVERED BY PRIVATE INS IN OCT12";
label variable PRINO12 "COVERED BY PRIVATE INS IN NOV12";
label variable PRIDE12 "COVERED BY PRIVATE INS IN DEC12";
label variable HPEJA12 "HOLDER OF EMPL UNION INS IN JAN12";
label variable HPEFE12 "HOLDER OF EMPL UNION INS IN FEB12";
label variable HPEMA12 "HOLDER OF EMPL UNION INS IN MAR12";
label variable HPEAP12 "HOLDER OF EMPL UNION INS IN APR12";
label variable HPEMY12 "HOLDER OF EMPL UNION INS IN MAY12";
label variable HPEJU12 "HOLDER OF EMPL UNION INS IN JUN12";
label variable HPEJL12 "HOLDER OF EMPL UNION INS IN JUL12";
label variable HPEAU12 "HOLDER OF EMPL UNION INS IN AUG12";
label variable HPESE12 "HOLDER OF EMPL UNION INS IN SEP12";
label variable HPEOC12 "HOLDER OF EMPL UNION INS IN OCT12";
label variable HPENO12 "HOLDER OF EMPL UNION INS IN NOV12";
label variable HPEDE12 "HOLDER OF EMPL UNION INS IN DEC12";
label variable HPDJA12 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN12";
label variable HPDFE12 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB12";
label variable HPDMA12 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR12";
label variable HPDAP12 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR12";
label variable HPDMY12 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY12";
label variable HPDJU12 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN12";
label variable HPDJL12 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL12";
label variable HPDAU12 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG12";
label variable HPDSE12 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP12";
label variable HPDOC12 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT12";
label variable HPDNO12 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV12";
label variable HPDDE12 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC12";
label variable HPNJA12 "HOLDER OF NONGROUP INS IN JAN12";
label variable HPNFE12 "HOLDER OF NONGROUP INS IN FEB12";
label variable HPNMA12 "HOLDER OF NONGROUP INS IN MAR12";
label variable HPNAP12 "HOLDER OF NONGROUP INS IN APR12";
label variable HPNMY12 "HOLDER OF NONGROUP INS IN MAY12";
label variable HPNJU12 "HOLDER OF NONGROUP INS IN JUN12";
label variable HPNJL12 "HOLDER OF NONGROUP INS IN JUL12";
label variable HPNAU12 "HOLDER OF NONGROUP INS IN AUG12";
label variable HPNSE12 "HOLDER OF NONGROUP INS IN SEP12";
label variable HPNOC12 "HOLDER OF NONGROUP INS IN OCT12";
label variable HPNNO12 "HOLDER OF NONGROUP INS IN NOV12";
label variable HPNDE12 "HOLDER OF NONGROUP INS IN DEC12";
label variable HPOJA12 "HOLDER OF OTHER GROUP INS IN JAN12";
label variable HPOFE12 "HOLDER OF OTHER GROUP INS IN FEB12";
label variable HPOMA12 "HOLDER OF OTHER GROUP INS IN MAR12";
label variable HPOAP12 "HOLDER OF OTHER GROUP INS IN APR12";
label variable HPOMY12 "HOLDER OF OTHER GROUP INS IN MAY12";
label variable HPOJU12 "HOLDER OF OTHER GROUP INS IN JUN12";
label variable HPOJL12 "HOLDER OF OTHER GROUP INS IN JUL12";
label variable HPOAU12 "HOLDER OF OTHER GROUP INS IN AUG12";
label variable HPOSE12 "HOLDER OF OTHER GROUP INS IN SEP12";
label variable HPOOC12 "HOLDER OF OTHER GROUP INS IN OCT12";
label variable HPONO12 "HOLDER OF OTHER GROUP INS IN NOV12";
label variable HPODE12 "HOLDER OF OTHER GROUP INS IN DEC12";
label variable HPSJA12 "HOLDER OF SELF-EMP-1 INS IN JAN12";
label variable HPSFE12 "HOLDER OF SELF-EMP-1 INS IN FEB12";
label variable HPSMA12 "HOLDER OF SELF-EMP-1 INS IN MAR12";
label variable HPSAP12 "HOLDER OF SELF-EMP-1 INS IN APR12";
label variable HPSMY12 "HOLDER OF SELF-EMP-1 INS IN MAY12";
label variable HPSJU12 "HOLDER OF SELF-EMP-1 INS IN JUN12";
label variable HPSJL12 "HOLDER OF SELF-EMP-1 INS IN JUL12";
label variable HPSAU12 "HOLDER OF SELF-EMP-1 INS IN AUG12";
label variable HPSSE12 "HOLDER OF SELF-EMP-1 INS IN SEP12";
label variable HPSOC12 "HOLDER OF SELF-EMP-1 INS IN OCT12";
label variable HPSNO12 "HOLDER OF SELF-EMP-1 INS IN NOV12";
label variable HPSDE12 "HOLDER OF SELF-EMP-1 INS IN DEC12";
label variable HPRJA12 "HOLDER OF PRIVATE INSURANCE IN JAN12";
label variable HPRFE12 "HOLDER OF PRIVATE INSURANCE IN FEB12";
label variable HPRMA12 "HOLDER OF PRIVATE INSURANCE IN MAR12";
label variable HPRAP12 "HOLDER OF PRIVATE INSURANCE IN APR12";
label variable HPRMY12 "HOLDER OF PRIVATE INSURANCE IN MAY12";
label variable HPRJU12 "HOLDER OF PRIVATE INSURANCE IN JUN12";
label variable HPRJL12 "HOLDER OF PRIVATE INSURANCE IN JUL12";
label variable HPRAU12 "HOLDER OF PRIVATE INSURANCE IN AUG12";
label variable HPRSE12 "HOLDER OF PRIVATE INSURANCE IN SEP12";
label variable HPROC12 "HOLDER OF PRIVATE INSURANCE IN OCT12";
label variable HPRNO12 "HOLDER OF PRIVATE INSURANCE IN NOV12";
label variable HPRDE12 "HOLDER OF PRIVATE INSURANCE IN DEC12";
label variable INSJA12X "COVR BY HOSP/MED INS IN JAN12 (ED)";
label variable INSFE12X "COVR BY HOSP/MED INS IN FEB12 (ED)";
label variable INSMA12X "COVR BY HOSP/MED INS IN MAR12 (ED)";
label variable INSAP12X "COVR BY HOSP/MED INS IN APR12 (ED)";
label variable INSMY12X "COVR BY HOSP/MED INS IN MAY12 (ED)";
label variable INSJU12X "COVR BY HOSP/MED INS IN JUN12 (ED)";
label variable INSJL12X "COVR BY HOSP/MED INS IN JUL12 (ED)";
label variable INSAU12X "COVR BY HOSP/MED INS IN AUG12 (ED)";
label variable INSSE12X "COVR BY HOSP/MED INS IN SEP12 (ED)";
label variable INSOC12X "COVR BY HOSP/MED INS IN OCT12 (ED)";
label variable INSNO12X "COVR BY HOSP/MED INS IN NOV12 (ED)";
label variable INSDE12X "COVR BY HOSP/MED INS IN DEC12 (ED)";
label variable PRVEV12 "EVER HAVE PRIVATE INSURANCE DURING 12";
label variable TRIEV12 "EVER HAVE TRICARE/CHAMPVA DURING 12";
label variable MCREV12 "EVER HAVE MEDICARE DURING 12 (ED)";
label variable MCDEV12 "EVER HAVE MEDICAID/SCHIP DURING 12 (ED)";
label variable OPAEV12 "EVER HAVE OTHER PUBLIC A INS DURING 12";
label variable OPBEV12 "EVER HAVE OTHER PUBLIC B INS DURING 12";
label variable UNINS12 "UNINSURED ALL OF 12";
label variable INSCOV12 "HEALTH INSURANCE COVERAGE INDICATOR 12";
label variable INSURC12 "FULL YEAR INSURANCE COVERAGE STATUS 2012";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST12X "COVERED BY TRICARE STANDARD - 12/31/12";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR12X "COVERED BY TRICARE PRIME - 12/31/12";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX12X "COVERED BY TRICARE EXTRA - 12/31/12";
label variable TRILI31X "COVERED BY TRICARE FOR LIFE - R3/1";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI12X "COVERED BY TRICARE FOR LIFE - 12/31/12";
label variable TRICH31X "COVERED BY TRICARE CHAMPVA - R3/1";
label variable TRICH42X "COVERED BY TRICARE CHAMPVA - R4/2";
label variable TRICH12X "COVERED BY TRICARE CHAMPVA - 12/31/12";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD12 "COV BY MEDICARE PMED BENEFIT - 12/31/12";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD12X "COV BY MCARE PMED BENEFIT-12/31/12 (ED)";
label variable MCRPB31 "COV BY MEDICARE PART B - R3/1";
label variable MCRPB42 "COV BY MEDICARE PART B - R4/2";
label variable MCRPB12 "COV BY MEDICARE PART B - 12/31/12";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE - R4/2";
label variable MCRPHO12 "COV BY MEDICARE MANAGED CARE - 12/31/12";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO12 "COVRED BY MEDICAID OR SCHIP HMO-12/31/12";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC12 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/12";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO12 "COVERED BY PRIVATE HMO - 12/31/12";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC12 "COVERED BY PRIV GATEKEEPER PLAN-12/31/12";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PRVDRL12 "COV BY PRIV PLAN W/DOCTOR LIST-12/31/12";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PHMONP12 "COV BY HMO-PAYS NON-PLAN DRS - 12/31/12";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PMNCNP12 "COV BY GATEKP-PAYS NON-PLAN DRS-12/31/12";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP12 "COV BY DR LIST-PAYS NON-PLAN DR-12/31/12";
label variable FSAGT31 "ANYONE IN RU HAVE FSA - R3/1";
label variable HASFSA31 "PERSON IS FSA HOLDER - R3/1";
label variable FSAAMT31 "FSA TOTAL AMOUNT FOR RU - R3/1";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 17 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 17 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 17 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 17 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 17 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 17 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 17 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 17 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 17 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 17 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 17 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 17 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 17 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 17 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 17 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 17 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 17 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 17 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PN 17 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 17 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 17 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 17 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 17 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR12X "COV BY TRICR/CHAMV - 12/31/12 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE/CHAMPVA - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE/CHAMPVA - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE/CHAMPVA - R5/3";
label variable TRIAT12X "ANY TIME COV TRICARE/CHAMPVA - 12/31/12";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID12 "COV BY MEDICAID OR SCHIP - 12/31/12";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID12X "COV BY MEDICAID OR SCHIP - 12/31/12 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE12 "COV BY MEDICARE - 12/31/12";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE12X "COV BY MEDICARE - 12/31/12 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT12X "ANY TIME COV MEDICAID OR SCHIP-12/31/12";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT12 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/12";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT12 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/12";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA12 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/12";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB12 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/12";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK12 "COV BY PRIV INS (DK PLAN) - 12/31/12";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU12 "COV BY EMPL/UNION GRP INS - 12/31/12";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING12 "COV BY NON-GROUP INS - 12/31/12";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG12 "COV BY OTHER GROUP INS - 12/31/12";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS12 "COV BY SELF-EMP-1 INS - 12/31/12";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV12 "COV BY PRIV HLTH INS - 12/31/12";
label variable PRIVAT31 "ANY TIME COV PRIVATE INS - R3/1";
label variable PRIVAT42 "ANY TIME COV PRIVATE INS - R4/2";
label variable PRIVAT53 "ANY TIME COV PRIVATE INS - R5/3";
label variable PRIVAT12 "ANY TIME COV PRIVATE INS - 12/31/12";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT12 "COV BY SOMEONE OUT OF RU - 12/31/12";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB12X "COV BY PUBLIC INS - 12/31/12 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV BY PUBLIC - R5/3";
label variable PUBAT12X "ANY TIME COV BY PUBLIC - 12/31/12";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS12X "INSURED - 12/31/12 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT12X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/12";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR12 "COV BY STATE-SPEC PROG - 12/31/12";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COVERAGE BY STATE INS - R5/3";
label variable STPRAT12 "ANY TIME COV BY STATE INS - 12/31/12";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable DNTINS31 "DENTAL INS - RD 3/1 IN 12";
label variable DNTINS12 "DENTAL INS - R5/R3 UNTIL 12/31/12";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 12";
label variable PMDINS12 "PMED INS - R5/R3 UNTIL 12/31/12";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable PMEDPP31 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R3/1";
label variable PMEDPP42 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R4/2";
label variable PMEDPP53 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R5/3";
label variable GDCPBM42 "MCAID/SCHIP/O PUB: PRB GET PERS DOC-R4/2";
label variable APRTRM42 "MCAID/SCHIP/O PUB: NEED APPRV 4 TRT-R4/2";
label variable APRDLM42 "MCAID/SCHIP/O PUB: DLY WAIT 4 APPRV-R4/2";
label variable LKINFM42 "MCAID/SCHIP/O PUB: LOOK 4 PLAN INFO-R4/2";
label variable PBINFM42 "MCAID/SCHIP/O PUB: PROB FINDNG INFO-R4/2";
label variable CSTSVM42 "MCAID/SCHIP/O PUB: CALL CUSTMR SERV-R4/2";
label variable PBSVCM42 "MCAID/SCHIP/O PUB: PRB W CUSRVC HLP-R4/2";
label variable PPRWKM42 "MCAID/SCHIP/O PUB: COMP PLAN PPRWRK-R4/2";
label variable PBPWKM42 "MCAID/SCHIP/O PUB: PRB W PLN PPRWRK-R4/2";
label variable RTPLNM42 "MCAID/SCHIP/O PUB: RATE EXP W PLAN-R4/2";
label variable GDCPBT42 "TRICR/CHAMV: PROB GETTING PERS DOC-R4/2";
label variable APRTRT42 "TRICR/CHAMV: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLT42 "TRICR/CHAMV: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFT42 "TRICR/CHAMV: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFT42 "TRICR/CHAMV: PROBLEM FINDING INFO-R4/2";
label variable CSTSVT42 "TRICR/CHAMV: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCT42 "TRICR/CHAMV: PROB GET HELP FR CSRVC-R4/2";
label variable PPRWKT42 "TRICR/CHAMV:FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKT42 "TRICR/CHAMV: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNT42 "TRICR/CHAMV: RATE EXPERIENCE W PLAN-R4/2";
label variable TOTTCH12 "TOTAL HEALTH CARE CHARGES 12, EXCL RX";
label variable TOTEXP12 "TOTAL HEALTH CARE EXP 12";
label variable TOTSLF12 "TOTAL AMT PAID BY SELF/FAMILY 12";
label variable TOTMCR12 "TOTAL AMT PAID BY MEDICARE 12";
label variable TOTMCD12 "TOTAL AMT PAID BY MEDICAID 12";
label variable TOTPRV12 "TOTAL AMT PAID BY PRIVATE INS 12";
label variable TOTVA12 "TOTAL AMT PAID BY VA/CHAMPVA 12";
label variable TOTTRI12 "TOTAL AMT PAID BY TRICARE 12";
label variable TOTOFD12 "TOTAL AMT PAID BY OTHER FEDERAL 12";
label variable TOTSTL12 "TOTAL AMT PAID BY OTH ST/LOCAL 12";
label variable TOTWCP12 "TOTAL AMT PAID BY WORKERS COMP 12";
label variable TOTOPR12 "TOTAL AMT PAID BY OTHER PRIVATE 12";
label variable TOTOPU12 "TOTAL AMT PAID BY OTHER PUBLIC 12";
label variable TOTOSR12 "TOTAL AMT PAID BY OTHER SOURCES 12";
label variable TOTPTR12 "TOTAL AMT PAID BY PRV & TRI 12";
label variable TOTOTH12 "TOTAL AMT PAID BY OTH COMBINED 12";
label variable OBTOTV12 "# OFFICE-BASED PROVIDER VISITS 12";
label variable OBVTCH12 "OFFICE-BASED PROVIDER VISIT CHARGES 12";
label variable OBVEXP12 "TOTAL OFFICE-BASED EXP 12";
label variable OBVSLF12 "ALL OFFICE VISITS - SELF/FAMILY AMT 12";
label variable OBVMCR12 "ALL OFFICE VISITS - MEDICARE AMT 12";
label variable OBVMCD12 "ALL OFFICE VISITS - MEDICAID AMT 12";
label variable OBVPRV12 "ALL OFFICE VISITS - PRIVATE INS AMT 12";
label variable OBVVA12 "ALL OFFICE VISITS-VA/CHAMPVA AMT 12";
label variable OBVTRI12 "ALL OFFICE VISITS-TRICARE AMT 12";
label variable OBVOFD12 "ALL OFFICE VISITS-OTHER FEDERAL AMT 12";
label variable OBVSTL12 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 12";
label variable OBVWCP12 "ALL OFFICE VISITS - WORKERS COMP AMT 12";
label variable OBVOPR12 "ALL OFFICE VISITS - OTH PRIVATE AMT 12";
label variable OBVOPU12 "ALL OFFICE VISITS - OTH PUBLIC AMT 12";
label variable OBVOSR12 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 12";
label variable OBVPTR12 "ALL OFFICE VISITS - PRV & TRI AMT 12";
label variable OBVOTH12 "ALL OFFICE VISITS - OTH COMBINED AMT 12";
label variable OBDRV12 "# OFFICE-BASED PHYSICIAN VISITS 12";
label variable OBDTCH12 "OFFICE-BASED PHYSICIAN VISIT CHARGES 12";
label variable OBDEXP12 "TOTAL OFF-BASED DR EXP 12";
label variable OBDSLF12 "DR OFFICE VISITS - SELF/FAMILY AMT 12";
label variable OBDMCR12 "DR OFFICE VISITS - MEDICARE AMT 12";
label variable OBDMCD12 "DR OFFICE VISITS - MEDICAID AMT 12";
label variable OBDPRV12 "DR OFFICE VISITS - PRIVATE INS AMT 12";
label variable OBDVA12 "DR OFFICE VISITS - VA/CHAMPVA AMT 12";
label variable OBDTRI12 "DR OFFICE VISITS - TRICARE AMT 12";
label variable OBDOFD12 "DR OFFICE VISITS - OTHER FEDERAL AMT 12";
label variable OBDSTL12 "DR OFFICE VISITS - OTH ST/LOCAL AMT 12";
label variable OBDWCP12 "DR OFFICE VISITS - WORKERS COMP AMT 12";
label variable OBDOPR12 "DR OFFICE VISITS - OTH PRIVATE AMT 12";
label variable OBDOPU12 "DR OFFICE VISITS - OTH PUBLIC AMT 12";
label variable OBDOSR12 "DR OFF VSTS - OTH UNCLASS SRCE AMT 12";
label variable OBDPTR12 "DR OFFICE VISITS - PRV & TRI AMT 12";
label variable OBDOTH12 "DR OFFICE VISITS - OTH COMBINED AMT 12";
label variable OBOTHV12 "# OFFICE-BASED NON-PHYSICAN VISITS 12";
label variable OBOTCH12 "OFFICE-BASED NON-DR VISIT CHARGES 12";
label variable OBOEXP12 "TOTAL OFF-BASED NON-DR EXP 12";
label variable OBOSLF12 "NON-DR OFF VISTS - SELF/FAMILY AMT 12";
label variable OBOMCR12 "NON-DR OFF VISTS - MEDICARE AMT 12";
label variable OBOMCD12 "NON-DR OFF VISTS - MEDICAID AMT 12";
label variable OBOPRV12 "NON-DR OFF VISTS - PRIVATE INS AMT 12";
label variable OBOVA12 "NON-DR OFF VISTS - VA/CHAMPVA AMT 12";
label variable OBOTRI12 "NON-DR OFF VISTS - TRICARE AMT 12";
label variable OBOOFD12 "NON-DR OFF VISTS - OTHER FEDERAL AMT 12";
label variable OBOSTL12 "NON-DR OFF VISTS - OTH ST/LOCAL AMT 12";
label variable OBOWCP12 "NON-DR OFF VISTS - WORKERS COMP AMT 12";
label variable OBOOPR12 "NON-DR OFF VISTS - OTH PRIVATE AMT 12";
label variable OBOOPU12 "NON-DR OFF VISTS - OTH PUBLIC AMT 12";
label variable OBOOSR12 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 12";
label variable OBOPTR12 "NON-DR OFF VISTS - PRV & TRI AMT 12";
label variable OBOOTH12 "NON-DR OFF VISTS - OTH COMBINED AMT 12";
label variable OBCHIR12 "# OFFICE-BASED CHIROPRACTOR VISITS 12";
label variable OBCTCH12 "OFFICE-BASED CHIRO VISIT CHARGES 12";
label variable OBCEXP12 "TOTAL OFF-BASED CHIRO EXP 12";
label variable OBCSLF12 "CHIRO OFF VISITS - SELF/FAMILY AMT 12";
label variable OBCMCR12 "CHIRO OFF VISITS - MEDICARE AMT 12";
label variable OBCMCD12 "CHIRO OFF VISITS - MEDICAID AMT 12";
label variable OBCPRV12 "CHIRO OFF VISITS - PRIVATE INS AMT 12";
label variable OBCVA12 "CHIRO OFF VISITS - VA/CHAMPVA AMT 12";
label variable OBCTRI12 "CHIRO OFF VISITS - TRICARE AMT 12";
label variable OBCOFD12 "CHIRO OFF VISITS - OTHER FEDERAL AMT 12";
label variable OBCSTL12 "CHIRO OFF VISITS - OTH ST/LOCAL AMT 12";
label variable OBCWCP12 "CHIRO OFF VISITS - WORKERS COMP AMT 12";
label variable OBCOPR12 "CHIRO OFF VISTS - OTHR PRIVATE AMT 12";
label variable OBCOPU12 "CHIRO OFF VISTS - OTHR PUBLIC AMT 12";
label variable OBCOSR12 "CHIRO OFF VSTS-OTHR UNCLASS SRCE AMT 12";
label variable OBCPTR12 "CHIRO OFF VISITS - PRV & TRI AMT 12";
label variable OBCOTH12 "CHIRO OFF VISITS -OTH COMBINED AMT 12";
label variable OBNURS12 "# OFF-BASED NURSE/PRACTITIONER VISITS 12";
label variable OBNTCH12 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 12";
label variable OBNEXP12 "TOTAL OFF-BASED NURSE/PRAC 12";
label variable OBNSLF12 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 12";
label variable OBNMCR12 "NURSE/PRAC OFF VISITS - MEDICARE AMT 12";
label variable OBNMCD12 "NURSE/PRAC OFF VSTS - MEDICAID AMT 12";
label variable OBNPRV12 "NURSE/PRAC OFF VSTS-PRIVATE INS AMT 12";
label variable OBNVA12 "NURSE/PRAC OFF VSTS - VA/CHAMPVA AMT 12";
label variable OBNTRI12 "NURSE/PRAC OFF VSTS - TRICARE AMT 12";
label variable OBNOFD12 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 12";
label variable OBNSTL12 "NURSE/PRAC OFF VSTS-OTH ST/LOCAL AMT 12";
label variable OBNWCP12 "NURSE/PRAC OFF VSTS-WORKERS COMP AMT 12";
label variable OBNOPR12 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 12";
label variable OBNOPU12 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 12";
label variable OBNOSR12 "NRS/PR OFF VSTS-OTH UNCLASS SRCE AMT 12";
label variable OBNPTR12 "NURSE/PRAC OFF VSTS - PRV & TRI AMT 12";
label variable OBNOTH12 "NURSE/PRAC OFF VSTS-OTH COMBINED AMT 12";
label variable OBOPTO12 "# OFF-BASED OPTOMETRIST VISITS 12";
label variable OBETCH12 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 12";
label variable OBEEXP12 "TOTAL OFF-BASED OPTOMETRIST EXP 12";
label variable OBESLF12 "OPTOMETRIST OFF VSTS-SELF/FAMILY AMT 12";
label variable OBEMCR12 "OPTOMETRIST OFF VSTS - MEDICARE AMT 12";
label variable OBEMCD12 "OPTOMETRIST OFF VSTS - MEDICAID AMT 12";
label variable OBEPRV12 "OPTOMETRIST OFF VSTS-PRIVATE INS AMT 12";
label variable OBEVA12 "OPTOMETRIST OFF VSTS - VA/CHAMPVA AMT 12";
label variable OBETRI12 "OPTOMETRIST OFF VSTS - TRICARE AMT 12";
label variable OBEOFD12 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 12";
label variable OBESTL12 "OPTOMETRIST OFF VSTS-OTH ST/LOCL AMT 12";
label variable OBEWCP12 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 12";
label variable OBEOPR12 "OPTOMETRIST OFF VSTS-OTH PRIVATE AMT 12";
label variable OBEOPU12 "OPTOMETRIST OFF VSTS - OTH PUBLIC AMT 12";
label variable OBEOSR12 "OPTOM OFF VSTS-OTH UNCLASS SRCE AMT 12";
label variable OBEPTR12 "OPTOMETRIST OFF VSTS - PRV & TRI AMT 12";
label variable OBEOTH12 "OPTOMETRIST OFF VSTS-OTH COMBINED AMT 12";
label variable OBASST12 "# OFF-BASED PHYSICIAN ASSIST VISITS 12";
label variable OBATCH12 "OFFICE-BASED PHYS ASST VISIT CHARGES 12";
label variable OBAEXP12 "TOTAL OFF-BASED PHYS ASS T EXP 12";
label variable OBASLF12 "PHYS ASS T OFF VSTS - SELF/FAMILY AMT 12";
label variable OBAMCR12 "PHYS ASS T OFF VSTS - MEDICARE AMT 12";
label variable OBAMCD12 "PHYS ASS T OFF VSTS - MEDICAID AMT 12";
label variable OBAPRV12 "PHYS ASS T OFF VSTS - PRIVATE INS AMT 12";
label variable OBAVA12 "PHYS ASS T OFF VSTS - VA/CHAMPVA AMT 12";
label variable OBATRI12 "PHYS ASS T OFF VSTS - TRICARE AMT 12";
label variable OBAOFD12 "PHYS ASS T OFF VSTS - OTHER FED AMT 12";
label variable OBASTL12 "PHYS ASS T OFF VSTS - OTH ST/LOCL AMT 12";
label variable OBAWCP12 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 12";
label variable OBAOPR12 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 12";
label variable OBAOPU12 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 12";
label variable OBAOSR12 "P A OFF VSTS - OTH UNCLASS SRCE AMT 12";
label variable OBAPTR12 "PHYS ASST OFF VSTS - PRV & TRI AMT 12";
label variable OBAOTH12 "PHYS ASST OFF VSTS - OTH COMBINED AMT 12";
label variable OBTHER12 "# OFF-BASED PT/OT VISITS 12";
label variable OBTTCH12 "OFFICE-BASED PT/OC VISIT CHARGES 12";
label variable OBTEXP12 "TOT OFF-BASED PT EXP 12";
label variable OBTSLF12 "PT/OT OFF VISITS - SELF/FAMILY AMT 12";
label variable OBTMCR12 "PT/OT OFF VISITS - MEDICARE AMT 12";
label variable OBTMCD12 "PT/OT OFF VISITS - MEDICAID AMT 12";
label variable OBTPRV12 "PT/OT OFF VISITS - PRIVATE INS AMT 12";
label variable OBTVA12 "PT/OT OFF VISITS - VA/CHAMPVA AMT 12";
label variable OBTTRI12 "PT/OT OFF VISITS - TRICARE AMT 12";
label variable OBTOFD12 "PT/OT OFF VISITS - OTHER FED AMT 12";
label variable OBTSTL12 "PT/OT OFF VISITS - OTH ST/LOCL AMT 12";
label variable OBTWCP12 "PT/OT OFF VISITS - WORKERS COMP AMT 12";
label variable OBTOPR12 "PT/OT OFF VISITS - OTH PRIVATE AMT 12";
label variable OBTOPU12 "PT/OT OFF VISITS - OTH PUBLIC AMT 12";
label variable OBTOSR12 "PT/OT OFF VSTS-OTH UNCLASS SRCE AMT 12";
label variable OBTPTR12 "PT/OT OFF VISITS - PRV & TRI AMT 12";
label variable OBTOTH12 "PT/OT OFF VISITS - OTH COMBINED AMT 12";
label variable OPTOTV12 "# OUTPATIENT DEPT PROVIDER VISITS 12";
label variable OPTTCH12 "OPD FACILITY + DR VISIT CHARGES - 12";
label variable OPTEXP12 "TOTAL OUTPATIENT FAC + DR EXP 12";
label variable OPTSLF12 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 12";
label variable OPTMCR12 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 12";
label variable OPTMCD12 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 12";
label variable OPTPRV12 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 12";
label variable OPTVA12 "ALL OPD VSTS-VA/CHAMPVA AMT-(FAC+DR) 12";
label variable OPTTRI12 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 12";
label variable OPTOFD12 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 12";
label variable OPTSTL12 "ALL OPD VST-OTH ST/LOCAL AMT(FAC+DR) 12";
label variable OPTWCP12 "ALL OPD VST-WORKRS COMP AMT-(FAC+DR) 12";
label variable OPTOPR12 "ALL OPD VSTS-OTH PRIVATE AMT-(FAC+DR) 12";
label variable OPTOPU12 "ALL OPD VSTS-OTH PUBLIC AMT-(FAC+DR) 12";
label variable OPTOSR12 "ALL OPD VST-OTH UNCLS SRC AMT(FAC+DR) 12";
label variable OPTPTR12 "ALL OPD VISITS-PRV & TRI AMT (FAC+DR) 12";
label variable OPTOTH12 "ALL OPD VSTS-OTH COMBINED AMT(FAC+DR) 12";
label variable OPFTCH12 "OPD PROVIDER VISIT CHARGES - FAC 12";
label variable OPFEXP12 "TOTAL OUTPATIENT FACILITY EXP 12";
label variable OPFSLF12 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 12";
label variable OPFMCR12 "ALL OPD VISITS-MEDICARE AMT-FAC 12";
label variable OPFMCD12 "ALL OPD VISITS-MEDICAID AMT-FAC 12";
label variable OPFPRV12 "ALL OPD VISITS-PRIV INS AMT-FAC 12";
label variable OPFVA12 "ALL OPD VISITS-VA/CHAMPVA AMT-FAC 12";
label variable OPFTRI12 "ALL OPD VISITS-TRICARE AMT-FAC 12";
label variable OPFOFD12 "ALL OPD VISITS-OTHER FED AMT-FAC 12";
label variable OPFSTL12 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 12";
label variable OPFWCP12 "ALL OPD VISITS-WORKERS COMP AMT-FAC 12";
label variable OPFOPR12 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 12";
label variable OPFOPU12 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 12";
label variable OPFOSR12 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 12";
label variable OPFPTR12 "ALL OPD VISITS - PRV & TRI AMT-FAC 12";
label variable OPFOTH12 "ALL OPD VISITS - OTH COMBINED AMT-FAC 12";
label variable OPDEXP12 "TOTAL OUTPATIENT PROVIDER EXP 12";
label variable OPDTCH12 "OPD PROVIDER VISIT CHARGES - DR 12";
label variable OPDSLF12 "ALL OPD VISITS-SELF/FAMILY AMT-DR 12";
label variable OPDMCR12 "ALL OPD VISITS-MEDICARE AMT-DR 12";
label variable OPDMCD12 "ALL OPD VISITS-MEDICAID AMT-DR 12";
label variable OPDPRV12 "ALL OPD VISITS-PRIV INS AMT-DR 12";
label variable OPDVA12 "ALL OPD VISITS-VA/CHAMPVA AMT-DR 12";
label variable OPDTRI12 "ALL OPD VISITS-TRICARE AMT-DR 12";
label variable OPDOFD12 "ALL OPD VISITS-OTHER FED AMT-DR 12";
label variable OPDSTL12 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 12";
label variable OPDWCP12 "ALL OPD VISITS-WORKERS COMP AMT-DR 12";
label variable OPDOPR12 "ALL OPD VISITS - OTH PRIVATE AMT-DR 12";
label variable OPDOPU12 "ALL OPD VISITS-OTH PUBLIC AMT-DR 12";
label variable OPDOSR12 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 12";
label variable OPDPTR12 "ALL OPD VISITS-PRV & TRI AMT -DR 12";
label variable OPDOTH12 "ALL OPD VISITS-OTH COMBINED AMT-DR 12";
label variable OPDRV12 "# OUTPATIENT DEPT PHYSICIAN VISITS 12";
label variable OPVTCH12 "OPD PHYSICIAN VISIT CHARGES - FAC 12";
label variable OPVEXP12 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 12";
label variable OPVSLF12 "OPD DR VISITS-SELF/FAMILY AMT-FAC 12";
label variable OPVMCR12 "OPD DR VISITS-MEDICARE AMT-FAC 12";
label variable OPVMCD12 "OPD DR VISITS-MEDICAID AMT-FAC 12";
label variable OPVPRV12 "OPD DR VISITS-PRIV INS AMT-FAC 12";
label variable OPVVA12 "OPD DR VISITS-VA/CHAMPVA AMT-FAC 12";
label variable OPVTRI12 "OPD DR VISITS-TRICARE AMT-FAC 12";
label variable OPVOFD12 "OPD DR VISITS-OTHER FED AMT-FAC 12";
label variable OPVSTL12 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 12";
label variable OPVWCP12 "OPD DR VISITS-WORKERS COMP AMT-FAC 12";
label variable OPVOPR12 "OPD DR VISITS - OTH PRIVATE AMT-FAC 12";
label variable OPVOPU12 "OPD DR VISITS-OTH PUBLIC AMT-FAC 12";
label variable OPVOSR12 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 12";
label variable OPVPTR12 "OPD DR VISITS - PRV & TRI AMT-FAC 12";
label variable OPVOTH12 "OPD DR VISITS - OTH COMBINED AMT-FAC 12";
label variable OPSEXP12 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 12";
label variable OPSTCH12 "OPD PHYSICIAN VISIT CHARGES - DR 12";
label variable OPSSLF12 "OPD DR VISITS-SELF/FAMILY AMT-DR 12";
label variable OPSMCR12 "OPD DR VISITS-MEDICARE AMT-DR 12";
label variable OPSMCD12 "OPD DR VISITS-MEDICAID AMT-DR 12";
label variable OPSPRV12 "OPD DR VISITS-PRIV INS AMT-DR 12";
label variable OPSVA12 "OPD DR VISITS-VA/CHAMPVA AMT-DR 12";
label variable OPSTRI12 "OPD DR VISITS-TRICARE AMT-DR 12";
label variable OPSOFD12 "OPD DR VISITS-OTHER FED AMT-DR 12";
label variable OPSSTL12 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 12";
label variable OPSWCP12 "OPD DR VISITS-WORKERS COMP AMT-DR 12";
label variable OPSOPR12 "OPD DR VISITS - OTH PRIVATE AMT-DR 12";
label variable OPSOPU12 "OPD DR VISITS-OTH PUBLIC AMT-DR 12";
label variable OPSOSR12 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 12";
label variable OPSPTR12 "OPD DR VISITS - PRV & TRI AMT-DR 12";
label variable OPSOTH12 "OPD DR VISITS -OTH COMBINED AMT-DR 12";
label variable OPOTHV12 "# OUTPATIENT DEPT NON-DR VISITS 12";
label variable OPOTCH12 "OPD NON-PHYS VISIT CHARGES - FAC 12";
label variable OPOEXP12 "TOTAL OUTPATIENT NON-DR - FAC EXP 12";
label variable OPOSLF12 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 12";
label variable OPOMCR12 "OPD NON-DR VISITS-MEDICARE AMT-FAC 12";
label variable OPOMCD12 "OPD NON-DR VISITS-MEDICAID AMT-FAC 12";
label variable OPOPRV12 "OPD NON-DR VISITS-PRIV INS AMT-FAC 12";
label variable OPOVA12 "OPD NON-DR VISITS-VA/CHAMPVA AMT-FAC 12";
label variable OPOTRI12 "OPD NON-DR VISITS-TRICARE AMT-FAC 12";
label variable OPOOFD12 "OPD NON-DR VISITS-OTHER FED AMT-FAC 12";
label variable OPOSTL12 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 12";
label variable OPOWCP12 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 12";
label variable OPOOPR12 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 12";
label variable OPOOPU12 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 12";
label variable OPOOSR12 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 12";
label variable OPOPTR12 "OPD NON-DR VISITS - PRV & TRI AMT-FAC 12";
label variable OPOOTH12 "OPD NON-DR VISITS-OTH COMBINED AM-FAC 12";
label variable OPPEXP12 "TOTAL OUTPATIENT NON-DR - DR EXP 12";
label variable OPPTCH12 "OPD NON-PHYS VISIT CHARGES - DR 12";
label variable OPPSLF12 "OPD NON-DR VISITS-SELF/FAM AMT-DR 12";
label variable OPPMCR12 "OPD NON-DR VISITS-MEDICARE AMT-DR 12";
label variable OPPMCD12 "OPD NON-DR VISITS-MEDICAID AMT-DR 12";
label variable OPPPRV12 "OPD NON-DR VISITS-PRIV INS AMT-DR 12";
label variable OPPVA12 "OPD NON-DR VISITS-VA/CHAMPVA AMT-DR 12";
label variable OPPTRI12 "OPD NON-DR VISITS-TRICARE AMT-DR 12";
label variable OPPOFD12 "OPD NON-DR VISITS-OTHER FED AMT-DR 12";
label variable OPPSTL12 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 12";
label variable OPPWCP12 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 12";
label variable OPPOPR12 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 12";
label variable OPPOPU12 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 12";
label variable OPPOSR12 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 12";
label variable OPPPTR12 "OPD NON-DR VISITS - PRV & TRI AMT-DR 12";
label variable OPPOTH12 "OPD NON-DR VISITS-OTH COMBINED AMT-DR 12";
label variable AMCHIR12 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2012";
label variable AMCTCH12 "CHIRO AMBULATORY VISIT CHARGES 12";
label variable AMCEXP12 "TOTL AMBULTRY (OB+OP) CHIRO EXP 12";
label variable AMCSLF12 "CHIRO AMB VISITS - SELF/FAMILY AMT 12";
label variable AMCMCR12 "CHIRO AMB VISITS - MEDICARE AMT 12";
label variable AMCMCD12 "CHIRO AMB VISITS - MEDICAID AMT 12";
label variable AMCPRV12 "CHIRO AMB VISITS - PRIVATE INS AMT 12";
label variable AMCVA12 "CHIRO AMB VISITS - VA/CHAMPVA AMT 12";
label variable AMCTRI12 "CHIRO AMB VISITS-TRICARE AMT 12";
label variable AMCOFD12 "CHIRO AMB VISITS - OTHER FEDERAL AMT 12";
label variable AMCSTL12 "CHIRO AMB VISITS - OTH ST/LOCAL AMT 12";
label variable AMCWCP12 "CHIRO AMB VISITS-WORKERS COMP AMT 12";
label variable AMCOPR12 "CHIRO AMB VISITS - OTH PRIVATE AMT 12";
label variable AMCOPU12 "CHIRO AMB VISITS - OTH PUBLIC AMT 12";
label variable AMCOSR12 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 12";
label variable AMCPTR12 "CHIRO AMB VISITS -PRV & TRI AMT 12";
label variable AMCOTH12 "CHIRO AMB VISITS - OTH COMBINED AMT 12";
label variable AMNURS12 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 12";
label variable AMNTCH12 "NRS/PRAC AMBULATORY VISIT CHARGES 12";
label variable AMNEXP12 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 12";
label variable AMNSLF12 "NRS/PRAC AMB VSTS - SELF/FAMILY AMT 12";
label variable AMNMCR12 "NRS/PRAC AMB VSTS - MEDICARE AMT 12";
label variable AMNMCD12 "NRS/PRAC AMB VSTS - MEDICAID AMT 12";
label variable AMNPRV12 "NRS/PRAC AMB VSTS - PRIV INS AMT 12";
label variable AMNVA12 "NRS/PRAC AMB VSTS-VA/CHAMPVA AMT 12";
label variable AMNTRI12 "NRS/PRAC AMB VSTS-TRICARE AMT 12";
label variable AMNOFD12 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 12";
label variable AMNSTL12 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 12";
label variable AMNWCP12 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 12";
label variable AMNOPR12 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 12";
label variable AMNOPU12 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 12";
label variable AMNOSR12 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 12";
label variable AMNPTR12 "NRS/PRAC AMB VSTS - PRV & TRI AMT 12";
label variable AMNOTH12 "NRS/PRAC AMB VSTS - OTH COMBINED AMT 12";
label variable AMOPTO12 "# AMB OPTOMETRIST VSTS (OB+OP) 12";
label variable AMETCH12 "OPTOMETRIST AMBULATORY VISIT CHARGES 12";
label variable AMEEXP12 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 12";
label variable AMESLF12 "OPTMTRIST AMB VSTS - SELF/FAMILY AMT 12";
label variable AMEMCR12 "OPTMTRIST AMB VSTS - MEDICARE AMT 12";
label variable AMEMCD12 "OPTMTRIST AMB VSTS - MEDICAID AMT 12";
label variable AMEPRV12 "OPTMTRIST AMB VSTS - PRIVATE INS AMT 12";
label variable AMEVA12 "OPTMTRIST AMB VSTS-VA/CHAMPVA AMT 12";
label variable AMETRI12 "OPTMTRIST AMB VSTS-TRICARE AMT 12";
label variable AMEOFD12 "OPTMTRIST AMB VSTS-OTHER FED AMT 12";
label variable AMESTL12 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 12";
label variable AMEWCP12 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 12";
label variable AMEOPR12 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 12";
label variable AMEOPU12 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 12";
label variable AMEOSR12 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 12";
label variable AMEPTR12 "OPTMTRIST AMB VSTS - PRV & TRI AMT 12";
label variable AMEOTH12 "OPTMTRIST AMB VSTS - OTH COMBINED AMT 12";
label variable AMASST12 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2012";
label variable AMATCH12 "PHYS ASS T AMBULATORY VISIT CHARGES 12";
label variable AMAEXP12 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 12";
label variable AMASLF12 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 12";
label variable AMAMCR12 "PHYS ASS T AMB VSTS-MEDICARE AMT 12";
label variable AMAMCD12 "PHYS ASS T AMB VSTS-MEDICAID AMT 12";
label variable AMAPRV12 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 12";
label variable AMAVA12 "PHYS ASS T AMB VSTS-VA/CHAMPVA AMT 12";
label variable AMATRI12 "PHYS ASS T AMB VSTS-TRICARE AMT 12";
label variable AMAOFD12 "PHYS ASS T AMB VSTS - OTHER FED AMT 12";
label variable AMASTL12 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 12";
label variable AMAWCP12 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 12";
label variable AMAOPR12 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 12";
label variable AMAOPU12 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 12";
label variable AMAOSR12 "P A AMB VSTS - OTH UNCLASS SRCE AMT 12";
label variable AMAPTR12 "PHYS ASS T AMB VSTS - PRV & TRI AMT 12";
label variable AMAOTH12 "PHYS ASS T AMB VSTS-OTH COMBINED AMT 12";
label variable AMTHER12 "# AMB PT/OT THRPY VISITS (OB+OP) 12";
label variable AMTTCH12 "PT/OC AMBULATORY VISIT CHARGES 12";
label variable AMTEXP12 "TOTL AMBULTRY (OB+OP) PT/OT EXP 12";
label variable AMTSLF12 "PT/OT AMB VISITS-SELF/FAMILY AMT 12";
label variable AMTMCR12 "PT/OT AMB VISITS-MEDICARE AMT 12";
label variable AMTMCD12 "PT/OT AMB VISITS-MEDICAID AMT 12";
label variable AMTPRV12 "PT/OT AMB VISITS-PRIVATE INS AMT 12";
label variable AMTVA12 "PT/OT AMB VISITS-VA/CHAMPVA AMT 12";
label variable AMTTRI12 "PT/OT AMB VISITS-TRICARE AMT 12";
label variable AMTOFD12 "PT/OT AMB VISITS - OTHER FED AMT 12";
label variable AMTSTL12 "PT/OT AMB VISITS-OTH ST/LOCL AMT 12";
label variable AMTWCP12 "PT/OT AMB VISITS-WORKERS COMP AMT 12";
label variable AMTOPR12 "PT/OT AMB VISITS - OTH PRIVATE AMT 12";
label variable AMTOPU12 "PT/OT AMB VISITS-OTH PUBLIC AMT 12";
label variable AMTOSR12 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 12";
label variable AMTPTR12 "PT/OT AMB VISITS -PRV & TRI AMT 12";
label variable AMTOTH12 "PT/OT AMB VISITS - OTH COMBINED AMT 12";
label variable AMTOTC12 "# CALLS W/OFFICE & OUPAT DEPTS, 2012";
label variable AMDRC12 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2012";
label variable ERTOT12 "# EMERGENCY ROOM VISITS 12";
label variable ERTTCH12 "ER FACILITY + DR VISIT CHARGES 12";
label variable ERTEXP12 "TOTAL ER FACILITY + DR EXP 12";
label variable ERTSLF12 "ER-SELF/FAMILY AMT-(FAC+DR) 12";
label variable ERTMCR12 "ER-MEDICARE AMT-(FAC+DR) 12";
label variable ERTMCD12 "ER-MEDICAID AMT-(FAC+DR) 12";
label variable ERTPRV12 "ER-PRIV INS AMT-(FAC+DR) 12";
label variable ERTVA12 "ER-VA/CHAMPVA AMT-(FAC+DR) 12";
label variable ERTTRI12 "ER-TRICARE AMT-(FAC+DR) 12";
label variable ERTOFD12 "ER-OTHER FED AMT-(FAC+DR) 12";
label variable ERTSTL12 "ER-OTH ST/LOCAL AMT-(FAC+DR) 12";
label variable ERTWCP12 "ER-WORKERS COMP AMT-(FAC+DR) 12";
label variable ERTOPR12 "ER-OTH PRIVATE AMT-(FAC+DR) 12";
label variable ERTOPU12 "ER-OTH PUBLIC AMT-(FAC+DR) 12";
label variable ERTOSR12 "ER-OTH UNCLASS SRCE AMT-(FAC+DR) 12";
label variable ERTPTR12 "ER-PRV & TRI AMT (FAC+DR) 12";
label variable ERTOTH12 "ER -OTH COMBINED AMT (FAC+DR) 12";
label variable ERFTCH12 "ER FACILITY VISIT CHARGES 12";
label variable ERFEXP12 "TOTAL ER FACILITY EXP 12";
label variable ERFSLF12 "ER-SELF/FAMILY AMT - FAC 12";
label variable ERFMCR12 "ER-MEDICARE AMT - FAC 12";
label variable ERFMCD12 "ER-MEDICAID AMT - FAC 12";
label variable ERFPRV12 "ER-PRIVATE INS AMT - FAC 12";
label variable ERFVA12 "ER-VA/CHAMPVA AMT - FAC 12";
label variable ERFTRI12 "ER-TRICARE AMT - FAC 12";
label variable ERFOFD12 "ER-OTHER FEDERAL AMT - FAC 12";
label variable ERFSTL12 "ER-OTH ST/LOCAL AMT - FAC 12";
label variable ERFWCP12 "ER-WORKERS COMP AMT - FAC 12";
label variable ERFOPR12 "ER-OTHER PRIVATE AMT - FAC 12";
label variable ERFOPU12 "ER-OTHER PUBLIC AMT - FAC 12";
label variable ERFOSR12 "ER-OTH UNCLASS SRCE AMT - FAC 12";
label variable ERFPTR12 "ER-PRV & TRI AMT - FAC 12";
label variable ERFOTH12 "ER-OTH COMBINED AMT - FAC 12";
label variable ERDEXP12 "TOTAL EMERGENCY ROOM DR EXP 12";
label variable ERDTCH12 "ER DOCTOR VISIT CHARGES 12";
label variable ERDSLF12 "ER-SELF/FAMILY AMT - DR 12";
label variable ERDMCR12 "ER-MEDICARE AMT - DR 12";
label variable ERDMCD12 "ER-MEDICAID AMT - DR 12";
label variable ERDPRV12 "ER-PRIVATE INS AMT - DR 12";
label variable ERDVA12 "ER-VA/CHAMPVA AMT - DR 12";
label variable ERDTRI12 "ER-TRICARE AMT - DR 12";
label variable ERDOFD12 "ER-OTHER FED AMT - DR 12";
label variable ERDSTL12 "ER-OTH ST/LOCAL AMT - DR 12";
label variable ERDWCP12 "ER-WORKERS COMP AMT - DR 12";
label variable ERDOPR12 "ER - OTHER PRIVATE AMT - DR 12";
label variable ERDOPU12 "ER - OTHER PUBLIC AMT - DR 12";
label variable ERDOSR12 "ER-OTH UNCLASS SRCE AMT - DR 12";
label variable ERDPTR12 "ER-PRV & TRI AMT - DR 12";
label variable ERDOTH12 "ER-OTH COMBINED AMT - DR 12";
label variable IPZERO12 "# ZERO-NIGHT HOSPITAL STAYS 12";
label variable ZIFTCH12 "ZERO-NITE IP STAY CHARGES - FAC 12";
label variable ZIFEXP12 "TOTAL ZERO-NITE STAYS FAC EXP 12";
label variable ZIFSLF12 "ZERO-NITE IP STAZ-SELF/FAM AMT-FAC 12";
label variable ZIFMCR12 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 12";
label variable ZIFMCD12 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 12";
label variable ZIFPRV12 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 12";
label variable ZIFVA12 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-FAC 12";
label variable ZIFTRI12 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 12";
label variable ZIFOFD12 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 12";
label variable ZIFSTL12 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 12";
label variable ZIFWCP12 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 12";
label variable ZIFOPR12 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 12";
label variable ZIFOPU12 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 12";
label variable ZIFOSR12 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 12";
label variable ZIFPTR12 "ZERO-NITE IP STAZ-PRV & TRI AMT-FAC 12";
label variable ZIFOTH12 "ZERO-NITE IP STAZ-OTH COMBINE AMT-FAC 12";
label variable ZIDEXP12 "TOTAL ZERO-NITE STAZ DR 12";
label variable ZIDTCH12 "ZERO-NITE IP STAY CHARGES - DR 12";
label variable ZIDSLF12 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 12";
label variable ZIDMCR12 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 12";
label variable ZIDMCD12 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 12";
label variable ZIDPRV12 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 12";
label variable ZIDVA12 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-DR 12";
label variable ZIDTRI12 "ZERO-NITE IP STAZ-TRICARE AMT-DR 12";
label variable ZIDOFD12 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 12";
label variable ZIDSTL12 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 12";
label variable ZIDWCP12 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 12";
label variable ZIDOPR12 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 12";
label variable ZIDOPU12 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 12";
label variable ZIDOSR12 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 12";
label variable ZIDPTR12 "ZERO-NITE IP STAZ-PRV & TRI AMT-DR 12";
label variable ZIDOTH12 "ZERO-NITE IP STAZ-OTH COMBINED AMT-DR 12";
label variable IPDIS12 "# HOSPITAL DISCHARGES, 2012";
label variable IPTEXP12 "TOT HOSP IP FACILITY + DR EXP 12";
label variable IPTTCH12 "IP HOSP STAY CHARGES (FAC+DR) 12";
label variable IPTSLF12 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 12";
label variable IPTMCR12 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 12";
label variable IPTMCD12 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 12";
label variable IPTPRV12 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 12";
label variable IPTVA12 "IP HOSP STAZ-VA/CHAMPVA AMT-(FAC+DR) 12";
label variable IPTTRI12 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 12";
label variable IPTOFD12 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 12";
label variable IPTSTL12 "IP HSP STAZ-OTH ST/LOCAL AMT-(FAC+DR) 12";
label variable IPTWCP12 "IP HOSP STAZ-WRKRS COMP AMT-(FAC+DR) 12";
label variable IPTOPR12 "IP HOSP STAZ-OTH PRIVATE AMT-(FAC+DR) 12";
label variable IPTOPU12 "IP HOSP STAZ-OTH PUBLIC AMT-(FAC+DR) 12";
label variable IPTOSR12 "IP HSP STAZ-OTH UNCLS SRC AMT(FAC+DR) 12";
label variable IPTPTR12 "IP HOSP STAZ-PRV & TRI AMT-(FAC+DR) 12";
label variable IPTOTH12 "IP HOSP STAZ-OTH COMBINED AMT(FAC+DR) 12";
label variable IPFEXP12 "TOT HOSP IP FACILITY EXP-INC 0 NITES 12";
label variable IPFTCH12 "IP HOSP STAY CHARGES - FAC 12";
label variable IPFSLF12 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 12";
label variable IPFMCR12 "IP HOSP STAZ-MEDICARE AMT-FAC 12";
label variable IPFMCD12 "IP HOSP STAZ-MEDICAID AMT-FAC 12";
label variable IPFPRV12 "IP HOSP STAZ-PRIV INS AMT-FAC 12";
label variable IPFVA12 "IP HOSP STAZ-VA/CHAMPVA AMT-FAC 12";
label variable IPFTRI12 "IP HOSP STAZ-TRICARE AMT-FAC 12";
label variable IPFOFD12 "IP HOSP STAZ-OTHER FED AMT-FAC 12";
label variable IPFSTL12 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 12";
label variable IPFWCP12 "IP HOSP STAZ-WORKERS COMP AMT-FAC 12";
label variable IPFOPR12 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 12";
label variable IPFOPU12 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 12";
label variable IPFOSR12 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 12";
label variable IPFPTR12 "IP HOSP STAZ-PRV & TRI AMT-FAC 12";
label variable IPFOTH12 "IP HOSP STAZ-OTH COMBINED AMT-FAC 12";
label variable IPDEXP12 "TOTL HOSP STAZ DR EXP 12";
label variable IPDTCH12 "IP HOSP STAY CHARGES - DR 12";
label variable IPDSLF12 "IP HOSP STAZ-SELF/FAMILY AMT-DR 12";
label variable IPDMCR12 "IP HOSP STAZ-MEDICARE AMT- DR 12";
label variable IPDMCD12 "IP HOSP STAZ-MEDICAID AMT-DR 12";
label variable IPDPRV12 "IP HOSP STAZ-PRIV INS AMT-DR 12";
label variable IPDVA12 "IP HOSP STAZ-VA/CHAMPVA AMT-DR 12";
label variable IPDTRI12 "IP HOSP STAZ-TRICARE AMT-DR 12";
label variable IPDOFD12 "IP HOSP STAZ-OTHER FED AMT-DR 12";
label variable IPDSTL12 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 12";
label variable IPDWCP12 "IP HOSP STAZ-WORKERS COMP AMT-DR 12";
label variable IPDOPR12 "IP HOSP STAZ - OTH PRIVATE AMT-DR 12";
label variable IPDOPU12 "IP HOSP STAZ - OTH PUBLIC AMT-DR 12";
label variable IPDOSR12 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 12";
label variable IPDPTR12 "IP HOSP STAZ-PRV & TRI AMT-DR 12";
label variable IPDOTH12 "IP HOSP STAZ-OTH COMBINED AMT-DR 12";
label variable IPNGTD12 "# NIGHTS IN HOSP FOR DISCHARGES, 2012";
label variable DVTOT12 "# DENTAL CARE VISITS 12";
label variable DVTTCH12 "TOTAL DENTAL CARE VISIT CHARGES 12";
label variable DVTEXP12 "TOTAL DENTAL CARE EXP 12";
label variable DVTSLF12 "ALL DENTAL CARE - SELF/FAMILY AMT 12";
label variable DVTMCR12 "ALL DENTAL CARE - MEDICARE AMT 12";
label variable DVTMCD12 "ALL DENTAL CARE - MEDICAID AMT 12";
label variable DVTPRV12 "ALL DENTAL CARE - PRIVATE INS AMT 12";
label variable DVTVA12 "ALL DENTAL CARE - VA/CHAMPVA AMT 12";
label variable DVTTRI12 "ALL DENTAL CARE - TRICARE AMT 12";
label variable DVTOFD12 "ALL DENTAL CARE - OTHER FEDRL AMT 12";
label variable DVTSTL12 "ALL DENTAL CARE - OTH ST/LOCAL AMT 12";
label variable DVTWCP12 "ALL DENTAL CARE - WORKERS COMP AMT 12";
label variable DVTOPR12 "ALL DENTAL CARE - OTH PRIVATE AMT 12";
label variable DVTOPU12 "ALL DENTAL CARE - OTH PUBLIC AMT 12";
label variable DVTOSR12 "ALL DENT CARE-OT UNCLASS SRCE AMT 12";
label variable DVTPTR12 "ALL DENTAL CARE - PRV & TRI AMT 12";
label variable DVTOTH12 "ALL DENTAL CARE - OTH COMBINED AMT 12";
label variable DVGEN12 "# GENERAL DENTIST VISITS 12";
label variable DVGTCH12 "GENERAL DENTAL CARE VISIT CHARGES 12";
label variable DVGEXP12 "TOTAL GENERAL DENTIST EXP 12";
label variable DVGSLF12 "GNRL DENTAL VISITS - SELF/FAM AMT 12";
label variable DVGMCR12 "GNRL DENTAL VISITS - MEDICARE AMT 12";
label variable DVGMCD12 "GNRL DENTAL VISITS - MEDICAID AMT 12";
label variable DVGPRV12 "GNRL DENTAL VISITS - PRIVATE INS AMT 12";
label variable DVGVA12 "GNRL DENTAL VISITS - VA/CHAMPVA AMT 12";
label variable DVGTRI12 "GNRL DENTAL VISITS-TRICARE AMT 12";
label variable DVGOFD12 "GNRL DENTAL VISITS - OTHER FED AMT 12";
label variable DVGSTL12 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 12";
label variable DVGWCP12 "GNRL DENTAL VISITS - WORKERS COMP AMT 12";
label variable DVGOPR12 "GNRL DENTAL VISITS - OTH PRIVATE AMT 12";
label variable DVGOPU12 "GNRL DENTAL VISITS - OTH PUBLIC AMT 12";
label variable DVGOSR12 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 12";
label variable DVGPTR12 "GNRL DENTAL VISITS - PRV & TRI AMT 12";
label variable DVGOTH12 "GNRL DENTAL VISITS - OTH COMBINED AMT 12";
label variable DVORTH12 "# ORTHODONTIST VISITS 12";
label variable DVOTCH12 "ORTHODONTIST VISIT CHARGES 12";
label variable DVOEXP12 "TOTAL ORTHODONTIST EXP 12";
label variable DVOSLF12 "ORTHODONTIST VISITS - SELF/FAMILY AMT 12";
label variable DVOMCR12 "ORTHODONTIST VISITS - MEDICARE AMT 12";
label variable DVOMCD12 "ORTHODONTIST VISITS - MEDICAID AMT 12";
label variable DVOPRV12 "ORTHODONTIST VISITS - PRIVATE INS AMT 12";
label variable DVOVA12 "ORTHODONTIST VISITS-VA/CHAMPVA AMT 12";
label variable DVOTRI12 "ORTHODONTIST VISITS-TRICARE AMT 12";
label variable DVOOFD12 "ORTHODONTIST VISITS-OTHR FED AMT 12";
label variable DVOSTL12 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 12";
label variable DVOWCP12 "ORTHODONTIST VISITS-WORKERS COMP AMT 12";
label variable DVOOPR12 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 12";
label variable DVOOPU12 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 12";
label variable DVOOSR12 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 12";
label variable DVOPTR12 "ORTHODONTIST VISITS - PRV & TRI AMT 12";
label variable DVOOTH12 "ORTHODONTIST VISITS-OTH COMBINED AMT 12";
label variable HHTOTD12 "# HOME HEALTH PROVIDER DAYS, 2012";
label variable HHAGD12 "# AGENCY HOME HEALTH PROVIDER DAYS 12";
label variable HHATCH12 "HOME HEALTH AGENCY VISIT CHARGES 12";
label variable HHAEXP12 "TOTAL HOME HEALTH AGENCY EXP 12";
label variable HHASLF12 "HOME HLTH AGENCY - SELF/FAMILY AMT 12";
label variable HHAMCR12 "HOME HLTH AGENCY - MEDICARE AMT 12";
label variable HHAMCD12 "HOME HLTH AGENCY - MEDICAID AMT 12";
label variable HHAPRV12 "HOME HLTH AGENCY - PRIVATE INS AMT 12";
label variable HHAVA12 "HOME HLTH AGENCY-VA/CHAMPVA AMT 12";
label variable HHATRI12 "HOME HLTH AGENCY-TRICARE AMT 12";
label variable HHAOFD12 "HOME HLTH AGENCY - OTHER FED AMT 12";
label variable HHASTL12 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 12";
label variable HHAWCP12 "HOME HLTH AGENCY - WORKERS COMP AMT 12";
label variable HHAOPR12 "HOME HLTH AGENCY - OTH PRIVATE AMT 12";
label variable HHAOPU12 "HOME HLTH AGENCY - OTH PUBLIC AMT 12";
label variable HHAOSR12 "H HLTH AGENCY - OT UNCLASS SRCE AMT 12";
label variable HHAPTR12 "HOME HLTH AGENCY - PRV & TRI AMT 12";
label variable HHAOTH12 "HOME HLTH AGENCY - OTH COMBINED AMT 12";
label variable HHINDD12 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 12";
label variable HHNTCH12 "HOME HEALTH NON-AGENCY VISIT CHARGES 12";
label variable HHNEXP12 "TOTAL HOME HEALTH NON-AGNCY EXP 12";
label variable HHNSLF12 "HOME HLTH NON-AGNCY - SELF/FAM AMT 12";
label variable HHNMCD12 "HOME HLTH NON-AGNCY - MEDICAID AMT 12";
label variable HHNMCR12 "HOME HLTH NON-AGNCY - MEDICARE AMT 12";
label variable HHNPRV12 "HOME HLTH NON-AGNCY - PRIV INS AMT 12";
label variable HHNVA12 "HOME HLTH NON-AGNCY-VA/CHAMPVA AMT 12";
label variable HHNTRI12 "HOME HLTH NON-AGNCY-TRICARE AMT 12";
label variable HHNOFD12 "HOME HLTH NON-AGNCY-OTHR FED AMT 12";
label variable HHNSTL12 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 12";
label variable HHNWCP12 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 12";
label variable HHNOPR12 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 12";
label variable HHNOPU12 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 12";
label variable HHNOSR12 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 12";
label variable HHNPTR12 "HOME HLTH NON-AGNCY - PRV & TRI AMT 12";
label variable HHNOTH12 "HOME HLTH NON-AGNCY-OTH COMBINED AMT 12";
label variable HHINFD12 "# INFORMAL HOME HEALTH PROVIDER DAYS 12";
label variable VISEXP12 "TOTAL GLASSES/CONTACT LENS EXP 12";
label variable VISTCH12 "GLASSES/CONTACT LENSES CHARGES 12";
label variable VISSLF12 "GLASSES/CNTCT LENSES -SELF/FAM AMT 12";
label variable VISMCR12 "GLASSES/CNTCT LENSES-MEDICARE AMT 12";
label variable VISMCD12 "GLASSES/CNTCT LENSES-MEDICAID AMT 12";
label variable VISPRV12 "GLASSES/CNTCT LENSES-PRIV INS AMT 12";
label variable VISVA12 "GLASSES/CNTCT LENSES-VA/CHAMPVA AMT 12";
label variable VISTRI12 "GLASSES/LENSES-TRICARE AMT 12";
label variable VISOFD12 "GLASSES/CNTCT LENSES-OTHR FED AMT 12";
label variable VISSTL12 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 12";
label variable VISWCP12 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 12";
label variable VISOPR12 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 12";
label variable VISOPU12 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 12";
label variable VISOSR12 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 12";
label variable VISPTR12 "GLASSES/CNTCT LENSES-PRV & TRI AMT 12";
label variable VISOTH12 "GLASSES/CNTCT LENSES-OTH COMBINED AMT 12";
label variable OTHTCH12 "OTHER EQUP/SUPPLIES CHARGES 12";
label variable OTHEXP12 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 12";
label variable OTHSLF12 "OTHER EQUP/SUPPLIES-SELF/FAM AMT 12";
label variable OTHMCR12 "OTHER EQUP/SUPPLIES-MEDICARE AMT 12";
label variable OTHMCD12 "OTHER EQUP/SUPPLIES-MEDICAID AMT 12";
label variable OTHPRV12 "OTHER EQUP/SUPPLIES-PRIV INS AMT 12";
label variable OTHVA12 "OTHER EQUP/SUPPLY-VA/CHAMPVA AMT 12";
label variable OTHTRI12 "OTHER EQUP/SUPPLY-TRICARE AMT 12";
label variable OTHOFD12 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 12";
label variable OTHSTL12 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 12";
label variable OTHWCP12 "OTHER EQUP/SUPPLY - WORKERS COMP AMT 12";
label variable OTHOPR12 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 12";
label variable OTHOPU12 "OTHER EQUP/SUPPLY - OTH PUBLIC AMT 12";
label variable OTHOSR12 "OTH EQUP/SUPLY - OT UNCLASS SRCE AMT 12";
label variable OTHPTR12 "OTHER EQUP/SUPPLY - PRV & TRI AMT 12";
label variable OTHOTH12 "OTHER EQUP/SUPPLY - OTH COMBINED AMT 12";
label variable RXTOT12 "# PRESC MEDS INCL REFILLS 12";
label variable RXEXP12 "TOTAL RX-EXP 12";
label variable RXSLF12 "TOTAL RX-SELF/FAMILY AMT 12";
label variable RXMCR12 "TOTAL RX-MEDICARE AMT 12";
label variable RXMCD12 "TOTAL RX-MEDICAID AMT 12";
label variable RXPRV12 "TOTAL RX-PRIVATE INS AMT 12";
label variable RXVA12 "TOTAL RX-VA/CHAMPVA AMT 12";
label variable RXTRI12 "TOTAL RX-TRICARE AMT 12";
label variable RXOFD12 "TOTAL RX-OTHER FED AMT 12";
label variable RXSTL12 "TOTAL RX-OTHER ST/LOCAL AMT 12";
label variable RXWCP12 "TOTAL RX-WORKERS COMP AMT 12";
label variable RXOPR12 "TOTAL RX-OTH PRIVATE AMT 12";
label variable RXOPU12 "TOTAL RX-OTH PUBLIC AMT 12";
label variable RXOSR12 "TOT RX-OTH UNCLASS SRCE AMT 12";
label variable RXPTR12 "TOTAL RX-PRV & TRI AMT 12";
label variable RXOTH12 "TOTAL RX-OTH COMBINED AMT 12";
label variable PERWT12F "FINAL PERSON WEIGHT, 2012";
label variable FAMWT12F "FINAL FAMILY WEIGHT, 2012";
label variable FAMWT12C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/12";
label variable SAQWT12F "FINAL SAQ PERSON WEIGHT, 2012";
label variable DIABW12F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2012";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2012";


*DEFINE VALUE LABELS FOR REPORTS;
label define H1550001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1550002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1550003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1550004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1550005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1550008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1550009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1550010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1550014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1550015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1550016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1550018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1550024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1550027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1550028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1550031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1550032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1550034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550037X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H1550038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1550043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1550044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1550046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1550047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H1550048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1550049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H1550050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1550051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1550053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1550054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1550056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1550057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1550060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1550062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1550066X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1550067X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H1550068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1550069X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550070X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550071X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1550072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550074X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1550076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1550077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RHEUMATOID ARTHRITIS"
         2 "2 OSTEOARTHRITIS"
         3 "3 NOT SPECIFIED" ;

label define H1550082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1550097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9  NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1550098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H1550099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550101X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1550103X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1550104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1550105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2011 "2011 YEAR"
         2012 "2012 YEAR" ;

label define H1550106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2012 "2012 YEAR" ;

label define H1550107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2012 "2012 YEAR"
         2013 "2013 YEAR" ;

label define H1550108X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1550109X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1550110X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550111X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550114X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1550117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550122X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1550123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1550125X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1550126X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1550127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1550128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1550129X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1550130X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550131X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550133X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550135X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550136X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550139X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550142X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1550150X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550152X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1550157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550161X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1550162X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1550163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1550164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550169X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1550170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550173X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550174X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1550177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550186X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550187X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550192X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1550195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1550196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1550197X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1550198X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1550199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550203X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H1550204X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1550205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1550208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1550219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H1550220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H1550222X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550223X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550224X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550225X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1550226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1550227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550229X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1550231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1550232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1550233X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1550234X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1550235X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1550236X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1550237X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1550241X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550242X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1550246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1550247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550248X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550249X
         -1 "-1 INAPPLICABLE"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H1550250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H1550251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE A1C BLOOD TEST" ;

label define H1550252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT CONFIDENT AT ALL"
         2 "2 SOMEWHAT CONFIDENT"
         3 "3 CONFIDENT"
         4 "4 VERY CONFIDENT" ;

label define H1550261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550266X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550273X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8  DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550285X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550286X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550287X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550289X
         -1 "-1 INAPPLICABLE OR UNDER 5"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 LESS THAN 1ST GRADE"
         1 "1 1ST GRADE"
         10 "10 10TH GRADE"
         11 "11 11TH GRADE"
         12 "12 12TH GRADE, NO HS DIPLOMA OR GED"
         13 "13 GED OR HS GRAD"
         14 "14 BEYOND HS,COLLEGE(NO 4YR DEG),ASSOC DEG"
         15 "15 4-YEAR COLLEGE DEGREE, BACHELOR'S DEGREE"
         16 "16 MASTER'S, DOCTORATE, OR PROFESSIONAL DEG"
         2 "2 2ND GRADE"
         3 "3 3RD GRADE"
         4 "4 4TH GRADE"
         5 "5 5TH GRADE"
         6 "6 6TH GRADE"
         7 "7 7TH GRADE"
         8 "8 8TH GRADE"
         9 "9 9TH GRADE" ;

label define H1550290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H1550291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 LESS THAN 1ST GRADE"
         1 "1 1ST GRADE"
         10 "10 10TH GRADE"
         11 "11 11TH GRADE"
         12 "12 12TH GRADE, NO DIPLOMA"
         13 "13 GED OR EQUIVALENT"
         14 "14 HIGH SCHOOL DIPLOMA"
         15 "15 SOME COLLEGE, NO DEGREE"
         16 "16 ASSOC DEG: OCCUPATIONAL,TECH,VOCATIONAL"
         17 "17 ASSOCIATE DEGREE: ACADEMIC PROGRAM"
         18 "18 BACHELOR'S DEGREE (BA,AB,BS,BBA)"
         19 "19 MASTER'S DEGREE (MA,MS,MENG,MED,MBA)"
         2 "2 2ND GRADE"
         20 "20 PROFESSIONAL SCHOOL"
         21 "21 DOCTORATE DEGREE (EXAMPLE: PHD,EDD)"
         22 "22 CHILD UNDER 5 YEARS OLD"
         3 "3 3RD GRADE"
         4 "4 4TH GRADE"
         5 "5 5TH GRADE"
         6 "6 6TH GRADE"
         7 "7 7TH GRADE"
         8 "8 8TH GRADE"
         9 "9 9TH GRADE" ;

label define H1550292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1550293X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1550294X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1550295X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1550296X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1550297X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550298X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550299X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H1550300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H1550301X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H1550302X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550305X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1550307X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1550308X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1550309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1550310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2012 "2012 YEAR" ;

label define H1550311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2012 "2012 YEAR" ;

label define H1550312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2012 "2012 YEAR" ;

label define H1550313X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2012 "2012 YEAR"
         2013 "2013 YEAR" ;

label define H1550314X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550315X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550316X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550320X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550321X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1550322X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1550323X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1550324X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1550325X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1550326X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550327X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H1550328X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H1550329X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1550330X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H1550331X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1550332X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1550333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550334X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550335X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H1550336X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550337X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550338X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1550339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1550340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1550341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1550342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1550343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1550344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1550345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE"
         2 "2 IS DRIVEN"
         3 "3 TAXI, BUS, TRAIN, OTHER PUBLIC TRANSPO"
         4 "4 WALKS"
         5 "5 SOME OTHER WAY" ;

label define H1550346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1550349X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550353X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H1550354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550359X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550360X
         0 "0.00"
         875 "$1 - $875" ;

label define H1550361X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550362X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550363X
         0 "0.00"
         2280 "$1 - $2,280" ;

label define H1550364X
         0 "0.00"
         2280 "$1 - $2,280" ;

label define H1550365X
         0 "0.00"
         300 "$1 - $300" ;

label define H1550366X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550369X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H1550370X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H1550371X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN/CUBAN AMERICAN"
         3 "3 DOMINICAN"
         4 "4 MEXICAN/MEXICAN AMERICAN"
         5 "5 CENTRAL OR SOUTH AMERICAN"
         6 "6 NON-HISPANIC"
         91 "91 OTHER LATIN AMERICAN"
         92 "92 OTHER HISPANIC/LATINO" ;

label define H1550372X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1550373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1550374X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1550375X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1550376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1550377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550378X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550379X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550389X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550395X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550414X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550415X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550416X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550417X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550418X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550419X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550420X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550421X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550422X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550423X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550424X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550425X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550426X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550427X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550428X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550429X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550430X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550431X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550432X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550433X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550434X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550435X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550436X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550437X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550438X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550439X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550440X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550441X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550442X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550443X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550444X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550445X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550446X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550447X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550448X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550449X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550450X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550451X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550452X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1550453X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1550454X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1550455X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $75.76"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550456X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $75.76"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550457X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $75.76"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550458X
         0 "0 NO"
         1 "1 YES" ;

label define H1550459X
         0 "0 NO"
         1 "1 YES" ;

label define H1550460X
         0 "0 NO"
         1 "1 YES" ;

label define H1550461X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550462X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550463X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550464X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550465X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550466X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550467X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550468X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550469X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550470X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550471X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1550472X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1550473X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1550474X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550475X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550476X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550477X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550478X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550480X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550481X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550484X
         1 "1 IN-SCOPE ON 12/31/2012"
         2 "2 NOT IN-SCOPE ON 12/31/2012" ;

label define H1550485X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/12"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1550486X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/12"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1550487X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/12"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1550488X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/12"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1550489X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2012"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2012" ;

label define H1550490X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H1550491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550492X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550493X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550494X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550495X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550496X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550497X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550498X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550499X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550500X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550501X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550502X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550503X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550504X
         -1 "-1 INAPPLICABLE"
         1 "1 <65 ANY PRIVATE"
         2 "2 <65 PUBLIC ONLY"
         3 "3 <65 UNINSURED"
         4 "4 65+ EDITED MEDICARE ONLY"
         5 "5 65+ EDITED MEDICARE AND PRIVATE"
         6 "6 65+ EDITED MEDICARE AND OTH PUB ONLY"
         7 "7 65+ UNINSURED"
         8 "8 65+ NO MEDICARE AND ANY PUBLIC/PRIVATE" ;

label define H1550505X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1550506X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H1550507X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550508X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550509X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1550510X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550511X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1550512X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1550513X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1550514X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550516X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550517X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550518X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550519X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H1550520X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1550521X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550522X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ANOTHER LANGUAGE" ;

label define H1550523X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550524X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550525X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550526X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550527X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1550528X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1550529X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550530X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550531X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H1550532X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1550533X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550534X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550535X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550536X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550537X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550538X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1550539X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H1550540X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1550541X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1550542X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1550543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550551X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550554X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550555X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550556X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550557X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550558X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550559X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550560X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550561X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550562X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550563X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550564X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550565X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550566X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550567X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550569X
         1 "1 YES"
         2 "2 NO" ;

label define H1550570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550572X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1550573X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1550574X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1550575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550582X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550583X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1550584X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1550585X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1550586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550589X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550592X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550594X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550595X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550596X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550597X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550598X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550599X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550600X
         1 "1 YES"
         2 "2 NO" ;

label define H1550601X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550602X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550603X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550604X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550605X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550606X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550607X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550608X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550609X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550610X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550611X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550612X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550613X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550614X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550615X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550616X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550617X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550618X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550619X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550620X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550621X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550622X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550623X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550624X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550625X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550626X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550627X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550628X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1550629X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550630X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550631X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550632X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550633X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550634X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1550635X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550636X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550637X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1550638X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550639X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550640X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1550641X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550642X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1550643X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550644X
         -1 "-1 INAPPLICALBE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550645X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550646X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1550647X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1550648X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550649X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1550650X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1550651X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1550652X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1550653X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550654X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550655X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550656X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550657X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1550658X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1550659X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1550660X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1550661X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1550662X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1550663X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1550664X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550665X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550666X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1550667X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1550668X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550669X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550670X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$75.76"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550671X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$75.76"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550672X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$75.76"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550673X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550674X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550675X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550676X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550677X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550678X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550679X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H1550680X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550681X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550682X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550683X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550684X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550685X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550686X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1550687X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1550688X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1550689X
         0 "0.00"
         121 "$1 - $121" ;

label define H1550690X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550691X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550692X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550693X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550694X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550695X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550696X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550697X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550698X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1550699X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1550700X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1550701X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550702X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550703X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550704X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550705X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550706X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550707X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550708X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550709X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550710X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550711X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550712X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550715X
         1 "1 YES"
         2 "2 NO" ;

label define H1550716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550728X
         1 "1 YES"
         2 "2 NO" ;

label define H1550729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550738X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550739X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550740X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550741X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550742X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550743X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550744X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1550745X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550746X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550747X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550748X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550749X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550750X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550751X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550752X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550753X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550754X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550755X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550756X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550757X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550758X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550759X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550760X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550761X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550762X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550763X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550764X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550765X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550766X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550767X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550768X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550769X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550770X
         16 "16 PANEL 16"
         17 "17 PANEL 17" ;

label define H1550771X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1550772X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550773X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550774X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550775X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550776X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550777X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550778X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550779X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550780X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550781X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550782X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550783X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550784X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550785X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550786X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550787X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550788X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550789X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550790X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550791X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550792X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550793X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550794X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550795X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550796X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550797X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550798X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550799X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550800X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550801X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550802X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550803X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550804X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550805X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550806X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550807X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550808X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550809X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1550810X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550811X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1550812X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1550813X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1550814X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1550815X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550816X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550817X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550818X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H1550819X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550820X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550821X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550822X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550823X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1550824X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550825X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550826X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550827X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550828X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550829X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1550830X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1550831X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1550832X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1550833X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550834X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550835X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550836X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1550837X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1550838X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1550839X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550840X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1550841X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1550842X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550843X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550844X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550845X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550846X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550847X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550848X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550849X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550850X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550851X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550852X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550853X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550854X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550855X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550856X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550857X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550858X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550859X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550860X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550861X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550862X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550863X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550864X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550865X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550866X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550867X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550868X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550869X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550870X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550871X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550872X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550873X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550874X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550875X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550876X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550877X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550878X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H1550879X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550880X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550881X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST-NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1550882X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1550883X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1550884X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550885X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550886X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550887X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550888X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550889X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550890X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550891X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550892X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550893X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550894X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550895X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550896X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550897X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550898X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550899X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550900X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550901X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550902X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550903X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550904X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550905X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550906X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550907X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550908X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550909X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550910X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550911X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550912X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550913X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550914X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550917X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550918X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550919X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550925X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550933X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H1550934X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1550935X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1550936X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1550937X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1550938X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550939X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550940X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550941X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550942X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550945X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550946X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550947X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550948X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550949X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550950X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1550951X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550952X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1550953X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1550954X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1550955X
         1 "1 YES"
         2 "2 NO" ;

label define H1550956X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1550957X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1550958X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1550959X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1550960X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1550961X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1550962X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1550963X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1550964X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1550965X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1550966X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550967X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550968X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550969X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550970X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550971X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550972X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550973X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550974X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550975X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550976X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550977X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550978X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1550979X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550980X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550981X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550982X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550983X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550984X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550985X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550986X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1550987X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1550988X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1550989X
         -1 "-1 INAPPLICABLE"
         1 "1 HISPANIC"
         2 "2 NON-HISPANIC WHITE ONLY"
         3 "3 NON-HISPANIC BLACK ONLY"
         4 "4 NON-HISPANIC ASIAN ONLY"
         5 "5 NON-HISPANIC OTHER RACE OR MULTIPLE RACE" ;

label define H1550990X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN - NO OTHER RACE REPORTED"
         5 "5 NATIVE HAWAIIAN/PACIFIC ISLANDER-NO OTHR"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H1550991X
         -1 "-1 INAPPLICABLE"
         1 "1 OLD RACE QUESTIONS"
         2 "2 NEW RACE QUESTIONS" ;

label define H1550992X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1550993X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1550994X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1550995X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550996X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550997X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1550998X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1550999X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1551000X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1551001X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1551002X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1551003X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1551004X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1551005X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1551006X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1551007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1551008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551009X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551010X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1551012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1551013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1551014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1551015X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H1551016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1551017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1551018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1551019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551021X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1551022X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1551023X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1551024X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1551025X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1551026X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1551027X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1551028X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1551029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551030X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1551031X
         0 "0 NOT ELIGIBLE FOR SAQ"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H1551032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1551033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1551036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1551037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1551038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1551039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H1551040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551041X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551043X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551044X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1551046X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H1551047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1551048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1551049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1551050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1551051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551052X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551053X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551060X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1551061X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1551062X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1551063X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YEARS OLD" ;

label define H1551064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1551065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1551066X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1551067X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1551068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1551069X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1551070X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABILITY"
         2 "2 SOME OTHER REASON" ;

label define H1551071X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1551072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1551073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1551074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1551075X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551076X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551077X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551078X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551079X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551080X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551081X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551082X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551083X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551084X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551085X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551086X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551087X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551088X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551089X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551090X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551092X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551093X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1551095X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1551096X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1551097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551098X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551099X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1551101X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1551102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551103X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1551104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1551105X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551106X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551107X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551108X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551109X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551110X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551111X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H1551112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1551113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1551114X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1551115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H1551121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H1551122X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1551124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551125X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551126X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551127X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551128X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551129X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551130X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551131X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551132X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551133X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551134X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551135X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551136X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551137X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551138X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551139X
         1 "1 YES"
         2 "2 NO" ;

label define H1551140X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551141X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551142X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551143X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551144X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551145X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551146X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551147X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551148X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551149X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551150X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551151X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551152X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551153X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551154X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551155X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551156X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551157X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1551158X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551159X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551160X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1551161X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1551162X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H1551163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551165X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1551166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1551167X
         1 "1 YES"
         2 "2 NO" ;

label define H1551168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551169X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551170X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551172X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1551174X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1551175X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H1551176X
         0 "0.00"
         107 "$1 - $107" ;

label define H1551177X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1551178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551186X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551187X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551192X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1551193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1551195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1551196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1551197X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1551198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1551199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1551200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1551201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1551202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1551203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1551204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1551205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1551207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1551208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1551209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1551212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1551213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1551217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1551219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1551220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1551221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1551222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1551223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEMS"
         91 "91 SOME OTHER REASON" ;

label define H1551224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 NO HEALTH INSURANCE"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         24 "24 INSURANCE-RELATED REASONS"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H1550001X;
label value ACTDTY31 H1550002X;
label value ACTDTY42 H1550003X;
label value ACTDTY53 H1550004X;
label value ACTLIM31 H1550005X;
label value ACTLIM53 H1550006X;
label value ADAPPT42 H1550007X;
label value ADCAPE42 H1550008X;
label value ADCLIM42 H1550009X;
label value ADCMPD42 H1550010X;
label value ADCMPM42 H1550011X;
label value ADCMPY42 H1550012X;
label value ADDAYA42 H1550013X;
label value ADDOWN42 H1550014X;
label value ADDPRS42 H1550015X;
label value ADDRBP42 H1550016X;
label value ADEFRT42 H1550017X;
label value ADEGMC42 H1550018X;
label value ADEXPL42 H1550019X;
label value ADEZUN42 H1550020X;
label value ADFFRM42 H1550021X;
label value ADFHLP42 H1550022X;
label value ADGENH42 H1550023X;
label value ADHDADDX H1550024X;
label value ADHDAGED H1550025X;
label value ADHECR42 H1550026X;
label value ADHOPE42 H1550027X;
label value ADILCR42 H1550028X;
label value ADILWW42 H1550029X;
label value ADINSA42 H1550030X;
label value ADINSB42 H1550031X;
label value ADINST42 H1550032X;
label value ADINTR42 H1550033X;
label value ADL3MO31 H1550034X;
label value ADL3MO42 H1550035X;
label value ADL3MO53 H1550036X;
label value ADLANG42 H1550037X;
label value ADLHLP31 H1550038X;
label value ADLHLP42 H1550039X;
label value ADLHLP53 H1550040X;
label value ADLIST42 H1550041X;
label value ADMALS42 H1550042X;
label value ADMWLM42 H1550043X;
label value ADNDCR42 H1550044X;
label value ADNERV42 H1550045X;
label value ADNRGY42 H1550046X;
label value ADNSMK42 H1550047X;
label value ADOVER42 H1550048X;
label value ADPAIN42 H1550049X;
label value ADPALS42 H1550050X;
label value ADPRTM42 H1550051X;
label value ADPRX42 H1550052X;
label value ADPWLM42 H1550053X;
label value ADRESP42 H1550054X;
label value ADREST42 H1550055X;
label value ADRISK42 H1550056X;
label value ADRTCR42 H1550057X;
label value ADRTWW42 H1550058X;
label value ADSAD42 H1550059X;
label value ADSMOK42 H1550060X;
label value ADSOCA42 H1550061X;
label value ADSPEC42 H1550062X;
label value ADSPRF42 H1550063X;
label value ADTLHW42 H1550064X;
label value ADUPRO42 H1550065X;
label value ADWRTH42 H1550066X;
label value AFDC12 H1550067X;
label value AFTHOU42 H1550068X;
label value AIDHLP31 H1550069X;
label value AIDHLP53 H1550070X;
label value ALIIMP12 H1550071X;
label value ANGIAGED H1550072X;
label value ANGIDX H1550073X;
label value ANYLIM12 H1550074X;
label value APRDLM42 H1550075X;
label value APRDLT42 H1550076X;
label value APRTRM42 H1550077X;
label value APRTRT42 H1550078X;
label value ARTHAGED H1550079X;
label value ARTHDX H1550080X;
label value ARTHTYPE H1550081X;
label value ASACUT53 H1550082X;
label value ASATAK31 H1550083X;
label value ASATAK53 H1550084X;
label value ASDALY53 H1550085X;
label value ASEVFL53 H1550086X;
label value ASIANP42 H1550087X;
label value ASMRCN53 H1550088X;
label value ASPKFL53 H1550089X;
label value ASPREV53 H1550090X;
label value ASPRIN53 H1550091X;
label value ASSTIL31 H1550092X;
label value ASSTIL53 H1550093X;
label value ASTHAGED H1550094X;
label value ASTHDX H1550095X;
label value ASTHEP31 H1550096X;
label value ASTHEP53 H1550097X;
label value ASWNFL53 H1550098X;
label value BEGRFD31 H1550099X;
label value BEGRFD42 H1550100X;
label value BEGRFD53 H1550101X;
label value BEGRFM31 H1550102X;
label value BEGRFM42 H1550103X;
label value BEGRFM53 H1550104X;
label value BEGRFY31 H1550105X;
label value BEGRFY42 H1550106X;
label value BEGRFY53 H1550107X;
label value BENDIF31 H1550108X;
label value BENDIF53 H1550109X;
label value BLCKPR42 H1550110X;
label value BLDRAGED H1550111X;
label value BLDRREMS H1550112X;
label value BLIND42 H1550113X;
label value BMINDX53 H1550114X;
label value BOOST42 H1550115X;
label value BPCHEK53 H1550116X;
label value BPMLDX H1550117X;
label value BPMONT53 H1550118X;
label value BRAIAGED H1550119X;
label value BRAIREMS H1550120X;
label value BRSTAGED H1550121X;
label value BRSTEX53 H1550122X;
label value BRSTREMS H1550123X;
label value BSNTY31 H1550124X;
label value BSNTY42 H1550125X;
label value BSNTY53 H1550126X;
label value BSTSRE53 H1550127X;
label value BSTST53 H1550128X;
label value BUSIMP12 H1550129X;
label value CABLADDR H1550130X;
label value CABRAIN H1550131X;
label value CABREAST H1550132X;
label value CACERVIX H1550133X;
label value CACOLON H1550134X;
label value CALEUKEM H1550135X;
label value CALUNG H1550136X;
label value CALYMPH H1550137X;
label value CAMELANO H1550138X;
label value CANCERDX H1550139X;
label value CAOTHER H1550140X;
label value CAPROSTA H1550141X;
label value CARECO42 H1550142X;
label value CASKINDK H1550143X;
label value CASKINNM H1550144X;
label value CATHROAT H1550145X;
label value CATHYROD H1550146X;
label value CERVAGED H1550147X;
label value CERVREMS H1550148X;
label value CHAPPT42 H1550149X;
label value CHBMIX42 H1550150X;
label value CHBRON31 H1550151X;
label value CHBRON53 H1550152X;
label value CHCOUN42 H1550153X;
label value CHDAGED H1550154X;
label value CHDDX H1550155X;
label value CHECK53 H1550156X;
label value CHEMPB42 H1550157X;
label value CHENEC42 H1550158X;
label value CHEXPL42 H1550159X;
label value CHEYRE42 H1550160X;
label value CHGJ3142 H1550161X;
label value CHGJ4253 H1550162X;
label value CHHECR42 H1550163X;
label value CHILCR42 H1550164X;
label value CHILWW42 H1550165X;
label value CHLICO42 H1550166X;
label value CHLIHB42 H1550167X;
label value CHLIMI42 H1550168X;
label value CHLIMP12 H1550169X;
label value CHLIST42 H1550170X;
label value CHNDCR42 H1550171X;
label value CHOIC31 H1550172X;
label value CHOIC42 H1550173X;
label value CHOIC53 H1550174X;
label value CHOLAGED H1550175X;
label value CHOLCK53 H1550176X;
label value CHOLDX H1550177X;
label value CHPMCN42 H1550178X;
label value CHPMED42 H1550179X;
label value CHPMHB42 H1550180X;
label value CHPRTM42 H1550181X;
label value CHRESP42 H1550182X;
label value CHRTCR42 H1550183X;
label value CHRTWW42 H1550184X;
label value CHSERV42 H1550185X;
label value CHSPEC42 H1550186X;
label value CHSRCN42 H1550187X;
label value CHSRHB42 H1550188X;
label value CHTHCO42 H1550189X;
label value CHTHER42 H1550190X;
label value CHTHHB42 H1550191X;
label value CLINIC42 H1550192X;
label value CLMDEP12 H1550193X;
label value CLMHIP12 H1550194X;
label value CLNTRE53 H1550195X;
label value CLNTST53 H1550196X;
label value COGLIM31 H1550197X;
label value COGLIM53 H1550198X;
label value COLOAGED H1550199X;
label value COLOREMS H1550200X;
label value COVRMM H1550201X;
label value COVRYY H1550202X;
label value CSHCN42 H1550203X;
label value CSHIMP12 H1550204X;
label value CSTSVM42 H1550205X;
label value CSTSVT42 H1550206X;
label value DADPRO42 H1550207X;
label value DDBDYS31 H1550208X;
label value DDBDYS42 H1550209X;
label value DDBDYS53 H1550210X;
label value DDNSCL31 H1550211X;
label value DDNSCL42 H1550212X;
label value DDNSCL53 H1550213X;
label value DDNWRK31 H1550214X;
label value DDNWRK42 H1550215X;
label value DDNWRK53 H1550216X;
label value DEAF42 H1550217X;
label value DECIDE42 H1550218X;
label value DEDUCT12 H1550219X;
label value DENTAL42 H1550220X;
label value DENTCK53 H1550221X;
label value DENTIN31 H1550222X;
label value DENTIN42 H1550223X;
label value DENTIN53 H1550224X;
label value DEPDNT12 H1550225X;
label value DFTOUS42 H1550226X;
label value DIABAGED H1550227X;
label value DIABDX H1550228X;
label value DIFFPL42 H1550229X;
label value DIFFWG31 H1550230X;
label value DIFFWG42 H1550231X;
label value DIFFWG53 H1550232X;
label value DISVW31X H1550233X;
label value DISVW42X H1550234X;
label value DISVW53X H1550235X;
label value DIVIMP12 H1550236X;
label value DKWHRU42 H1550237X;
label value DNDLAY42 H1550238X;
label value DNDLPR42 H1550239X;
label value DNDLRS42 H1550240X;
label value DNTINS12 H1550241X;
label value DNTINS31 H1550242X;
label value DNUNAB42 H1550243X;
label value DNUNPR42 H1550244X;
label value DNUNRS42 H1550245X;
label value DOBMM H1550246X;
label value DOBYY H1550247X;
label value DOCELS42 H1550248X;
label value DPINRU12 H1550249X;
label value DPOTSD12 H1550250X;
label value DSA1C53 H1550251X;
label value DSCB1153 H1550252X;
label value DSCGRP53 H1550253X;
label value DSCH1153 H1550254X;
label value DSCH1253 H1550255X;
label value DSCH1353 H1550256X;
label value DSCHNV53 H1550257X;
label value DSCINT53 H1550258X;
label value DSCNPC53 H1550259X;
label value DSCONF53 H1550260X;
label value DSCPCP53 H1550261X;
label value DSCPHN53 H1550262X;
label value DSDIA53 H1550263X;
label value DSDIET53 H1550264X;
label value DSEB1153 H1550265X;
label value DSEY1153 H1550266X;
label value DSEY1253 H1550267X;
label value DSEY1353 H1550268X;
label value DSEYNV53 H1550269X;
label value DSEYPR53 H1550270X;
label value DSFB1153 H1550271X;
label value DSFL1153 H1550272X;
label value DSFL1253 H1550273X;
label value DSFL1353 H1550274X;
label value DSFLNV53 H1550275X;
label value DSFT1153 H1550276X;
label value DSFT1253 H1550277X;
label value DSFT1353 H1550278X;
label value DSFTNV53 H1550279X;
label value DSINSU53 H1550280X;
label value DSKIDN53 H1550281X;
label value DSMED53 H1550282X;
label value DSPRX53 H1550283X;
label value DSVB1153 H1550284X;
label value DVGEN12 H1550285X;
label value DVORTH12 H1550286X;
label value DVTOT12 H1550287X;
label value EATHLT42 H1550288X;
label value EDRECODE H1550289X;
label value EDUCYR H1550290X;
label value EDUYRDEG H1550291X;
label value EICRDT12 H1550292X;
label value ELGRND12 H1550293X;
label value ELGRND31 H1550294X;
label value ELGRND42 H1550295X;
label value ELGRND53 H1550296X;
label value EMPHAGED H1550297X;
label value EMPHDX H1550298X;
label value EMPST31 H1550299X;
label value EMPST42 H1550300X;
label value EMPST53 H1550301X;
label value ENDRFD12 H1550302X;
label value ENDRFD31 H1550303X;
label value ENDRFD42 H1550304X;
label value ENDRFD53 H1550305X;
label value ENDRFM12 H1550306X;
label value ENDRFM31 H1550307X;
label value ENDRFM42 H1550308X;
label value ENDRFM53 H1550309X;
label value ENDRFY12 H1550310X;
label value ENDRFY31 H1550311X;
label value ENDRFY42 H1550312X;
label value ENDRFY53 H1550313X;
label value ENGCMF42 H1550314X;
label value ENGSPK42 H1550315X;
label value ERTOT12 H1550316X;
label value EVRETIRE H1550317X;
label value EVRWRK H1550318X;
label value EXPLOP42 H1550319X;
label value EXRCIS53 H1550320X;
label value FAMRFPYR H1550321X;
label value FAMSZE31 H1550322X;
label value FAMSZE42 H1550323X;
label value FAMSZE53 H1550324X;
label value FCRP1231 H1550325X;
label value FILEDR12 H1550326X;
label value FILER12 H1550327X;
label value FLSTAT12 H1550328X;
label value FLUSHT53 H1550329X;
label value FMRS1231 H1550330X;
label value FNGRDF31 H1550331X;
label value FNGRDF53 H1550332X;
label value FOODMN12 H1550333X;
label value FOODST12 H1550334X;
label value FOODVL12 H1550335X;
label value FSAAMT31 H1550336X;
label value FSAGT31 H1550337X;
label value FTSTU12X H1550338X;
label value FTSTU31X H1550339X;
label value FTSTU42X H1550340X;
label value FTSTU53X H1550341X;
label value GDCPBM42 H1550342X;
label value GDCPBT42 H1550343X;
label value GENDRP42 H1550344X;
label value GOTOUS42 H1550345X;
label value HASFSA31 H1550346X;
label value HAVEUS42 H1550347X;
label value HAVFUN42 H1550348X;
label value HEALTH42 H1550349X;
label value HEARAD42 H1550350X;
label value HEARDI42 H1550351X;
label value HEARMO42 H1550352X;
label value HEARNG42 H1550353X;
label value HEARSM42 H1550354X;
label value HELD31X H1550355X;
label value HELD42X H1550356X;
label value HELD53X H1550357X;
label value HELMET42 H1550358X;
label value HHAGD12 H1550359X;
label value HHAOPU12 H1550360X;
label value HHINDD12 H1550361X;
label value HHINFD12 H1550362X;
label value HHNOTH12 H1550363X;
label value HHNSTL12 H1550364X;
label value HHNVA12 H1550365X;
label value HHTOTD12 H1550366X;
label value HIBPAGED H1550367X;
label value HIBPDX H1550368X;
label value HIDEG H1550369X;
label value HISPANX H1550370X;
label value HISPCAT H1550371X;
label value HLTHLF42 H1550372X;
label value HOMEBH42 H1550373X;
label value HONRDC31 H1550374X;
label value HONRDC42 H1550375X;
label value HONRDC53 H1550376X;
label value HOUR31 H1550377X;
label value HOUR42 H1550378X;
label value HOUR53 H1550379X;
label value HPDAP12 H1550380X;
label value HPDAU12 H1550381X;
label value HPDDE12 H1550382X;
label value HPDFE12 H1550383X;
label value HPDJA12 H1550384X;
label value HPDJL12 H1550385X;
label value HPDJU12 H1550386X;
label value HPDMA12 H1550387X;
label value HPDMY12 H1550388X;
label value HPDNO12 H1550389X;
label value HPDOC12 H1550390X;
label value HPDSE12 H1550391X;
label value HPEAP12 H1550392X;
label value HPEAU12 H1550393X;
label value HPEDE12 H1550394X;
label value HPEFE12 H1550395X;
label value HPEJA12 H1550396X;
label value HPEJL12 H1550397X;
label value HPEJU12 H1550398X;
label value HPEMA12 H1550399X;
label value HPEMY12 H1550400X;
label value HPENO12 H1550401X;
label value HPEOC12 H1550402X;
label value HPESE12 H1550403X;
label value HPNAP12 H1550404X;
label value HPNAU12 H1550405X;
label value HPNDE12 H1550406X;
label value HPNFE12 H1550407X;
label value HPNJA12 H1550408X;
label value HPNJL12 H1550409X;
label value HPNJU12 H1550410X;
label value HPNMA12 H1550411X;
label value HPNMY12 H1550412X;
label value HPNNO12 H1550413X;
label value HPNOC12 H1550414X;
label value HPNSE12 H1550415X;
label value HPOAP12 H1550416X;
label value HPOAU12 H1550417X;
label value HPODE12 H1550418X;
label value HPOFE12 H1550419X;
label value HPOJA12 H1550420X;
label value HPOJL12 H1550421X;
label value HPOJU12 H1550422X;
label value HPOMA12 H1550423X;
label value HPOMY12 H1550424X;
label value HPONO12 H1550425X;
label value HPOOC12 H1550426X;
label value HPOSE12 H1550427X;
label value HPRAP12 H1550428X;
label value HPRAU12 H1550429X;
label value HPRDE12 H1550430X;
label value HPRFE12 H1550431X;
label value HPRJA12 H1550432X;
label value HPRJL12 H1550433X;
label value HPRJU12 H1550434X;
label value HPRMA12 H1550435X;
label value HPRMY12 H1550436X;
label value HPRNO12 H1550437X;
label value HPROC12 H1550438X;
label value HPRSE12 H1550439X;
label value HPSAP12 H1550440X;
label value HPSAU12 H1550441X;
label value HPSDE12 H1550442X;
label value HPSFE12 H1550443X;
label value HPSJA12 H1550444X;
label value HPSJL12 H1550445X;
label value HPSJU12 H1550446X;
label value HPSMA12 H1550447X;
label value HPSMY12 H1550448X;
label value HPSNO12 H1550449X;
label value HPSOC12 H1550450X;
label value HPSSE12 H1550451X;
label value HRHOW31 H1550452X;
label value HRHOW42 H1550453X;
label value HRHOW53 H1550454X;
label value HRWG31X H1550455X;
label value HRWG42X H1550456X;
label value HRWG53X H1550457X;
label value HRWGIM31 H1550458X;
label value HRWGIM42 H1550459X;
label value HRWGIM53 H1550460X;
label value HSELIM31 H1550461X;
label value HSELIM53 H1550462X;
label value HSPLAP42 H1550463X;
label value HYSTER53 H1550464X;
label value IADL3M31 H1550465X;
label value IADL3M42 H1550466X;
label value IADL3M53 H1550467X;
label value IADLHP31 H1550468X;
label value IADLHP42 H1550469X;
label value IADLHP53 H1550470X;
label value INDCAT31 H1550471X;
label value INDCAT42 H1550472X;
label value INDCAT53 H1550473X;
label value INS12X H1550474X;
label value INS31X H1550475X;
label value INS42X H1550476X;
label value INS53X H1550477X;
label value INSAP12X H1550478X;
label value INSAT12X H1550479X;
label value INSAT31X H1550480X;
label value INSAT42X H1550481X;
label value INSAT53X H1550482X;
label value INSAU12X H1550483X;
label value INSC1231 H1550484X;
label value INSCOP12 H1550485X;
label value INSCOP31 H1550486X;
label value INSCOP42 H1550487X;
label value INSCOP53 H1550488X;
label value INSCOPE H1550489X;
label value INSCOV12 H1550490X;
label value INSDE12X H1550491X;
label value INSENDMM H1550492X;
label value INSENDYY H1550493X;
label value INSFE12X H1550494X;
label value INSJA12X H1550495X;
label value INSJL12X H1550496X;
label value INSJU12X H1550497X;
label value INSMA12X H1550498X;
label value INSMY12X H1550499X;
label value INSNO12X H1550500X;
label value INSOC12X H1550501X;
label value INSRPL42 H1550502X;
label value INSSE12X H1550503X;
label value INSURC12 H1550504X;
label value INTIMP12 H1550505X;
label value INTVLANG H1550506X;
label value IPDIS12 H1550507X;
label value IPZERO12 H1550508X;
label value IRAIMP12 H1550509X;
label value JNTPID12 H1550510X;
label value JOBORG31 H1550511X;
label value JOBORG42 H1550512X;
label value JOBORG53 H1550513X;
label value JOBRSN42 H1550514X;
label value JTINRU12 H1550515X;
label value JTPAIN31 H1550516X;
label value JTPAIN53 H1550517X;
label value K6SUM42 H1550518X;
label value KEYNESS H1550519X;
label value KIDPRO42 H1550520X;
label value KNOWDR42 H1550521X;
label value LANGHM42 H1550522X;
label value LANGPR42 H1550523X;
label value LAPBLT42 H1550524X;
label value LEUKAGED H1550525X;
label value LEUKREMS H1550526X;
label value LFTDIF31 H1550527X;
label value LFTDIF53 H1550528X;
label value LKINFM42 H1550529X;
label value LKINFT42 H1550530X;
label value LOCATN42 H1550531X;
label value LSHLTH42 H1550532X;
label value LSTETH53 H1550533X;
label value LUNGAGED H1550534X;
label value LUNGREMS H1550535X;
label value LYMPAGED H1550536X;
label value LYMPREMS H1550537X;
label value MAMOGR53 H1550538X;
label value MARRY12X H1550539X;
label value MARRY31X H1550540X;
label value MARRY42X H1550541X;
label value MARRY53X H1550542X;
label value MCAID12 H1550543X;
label value MCAID12X H1550544X;
label value MCAID31 H1550545X;
label value MCAID31X H1550546X;
label value MCAID42 H1550547X;
label value MCAID42X H1550548X;
label value MCAID53 H1550549X;
label value MCAID53X H1550550X;
label value MCARE12 H1550551X;
label value MCARE12X H1550552X;
label value MCARE31 H1550553X;
label value MCARE31X H1550554X;
label value MCARE42 H1550555X;
label value MCARE42X H1550556X;
label value MCARE53 H1550557X;
label value MCARE53X H1550558X;
label value MCDAP12 H1550559X;
label value MCDAP12X H1550560X;
label value MCDAT12X H1550561X;
label value MCDAT31X H1550562X;
label value MCDAT42X H1550563X;
label value MCDAT53X H1550564X;
label value MCDAU12 H1550565X;
label value MCDAU12X H1550566X;
label value MCDDE12 H1550567X;
label value MCDDE12X H1550568X;
label value MCDEV12 H1550569X;
label value MCDFE12 H1550570X;
label value MCDFE12X H1550571X;
label value MCDHMO12 H1550572X;
label value MCDHMO31 H1550573X;
label value MCDHMO42 H1550574X;
label value MCDJA12 H1550575X;
label value MCDJA12X H1550576X;
label value MCDJL12 H1550577X;
label value MCDJL12X H1550578X;
label value MCDJU12 H1550579X;
label value MCDJU12X H1550580X;
label value MCDMA12 H1550581X;
label value MCDMA12X H1550582X;
label value MCDMC12 H1550583X;
label value MCDMC31 H1550584X;
label value MCDMC42 H1550585X;
label value MCDMY12 H1550586X;
label value MCDMY12X H1550587X;
label value MCDNO12 H1550588X;
label value MCDNO12X H1550589X;
label value MCDOC12 H1550590X;
label value MCDOC12X H1550591X;
label value MCDSE12 H1550592X;
label value MCDSE12X H1550593X;
label value MCRAP12 H1550594X;
label value MCRAP12X H1550595X;
label value MCRAU12 H1550596X;
label value MCRAU12X H1550597X;
label value MCRDE12 H1550598X;
label value MCRDE12X H1550599X;
label value MCREV12 H1550600X;
label value MCRFE12 H1550601X;
label value MCRFE12X H1550602X;
label value MCRJA12 H1550603X;
label value MCRJA12X H1550604X;
label value MCRJL12 H1550605X;
label value MCRJL12X H1550606X;
label value MCRJU12 H1550607X;
label value MCRJU12X H1550608X;
label value MCRMA12 H1550609X;
label value MCRMA12X H1550610X;
label value MCRMY12 H1550611X;
label value MCRMY12X H1550612X;
label value MCRNO12 H1550613X;
label value MCRNO12X H1550614X;
label value MCROC12 H1550615X;
label value MCROC12X H1550616X;
label value MCRPB12 H1550617X;
label value MCRPB31 H1550618X;
label value MCRPB42 H1550619X;
label value MCRPD12 H1550620X;
label value MCRPD12X H1550621X;
label value MCRPD31 H1550622X;
label value MCRPD31X H1550623X;
label value MCRPD42 H1550624X;
label value MCRPD42X H1550625X;
label value MCRPHO12 H1550626X;
label value MCRPHO31 H1550627X;
label value MCRPHO42 H1550628X;
label value MCRSE12 H1550629X;
label value MCRSE12X H1550630X;
label value MCS42 H1550631X;
label value MDDLAY42 H1550632X;
label value MDDLPR42 H1550633X;
label value MDDLRS42 H1550634X;
label value MDUNAB42 H1550635X;
label value MDUNPR42 H1550636X;
label value MDUNRS42 H1550637X;
label value MELAAGED H1550638X;
label value MELAREMS H1550639X;
label value MESBPR42 H1550640X;
label value MESHGT42 H1550641X;
label value MESVIS42 H1550642X;
label value MESWGT42 H1550643X;
label value MIAGED H1550644X;
label value MIDX H1550645X;
label value MILDIF31 H1550646X;
label value MILDIF53 H1550647X;
label value MINORP42 H1550648X;
label value MNHLTH31 H1550649X;
label value MNHLTH42 H1550650X;
label value MNHLTH53 H1550651X;
label value MOMPRO42 H1550652X;
label value MORE31 H1550653X;
label value MORE42 H1550654X;
label value MORE53 H1550655X;
label value MORECOVR H1550656X;
label value MORJOB31 H1550657X;
label value MORJOB42 H1550658X;
label value MORJOB53 H1550659X;
label value MSA12 H1550660X;
label value MSA31 H1550661X;
label value MSA42 H1550662X;
label value MSA53 H1550663X;
label value MYSELF42 H1550664X;
label value NATAMP42 H1550665X;
label value NERVAF42 H1550666X;
label value NEVILL42 H1550667X;
label value NEWARE42 H1550668X;
label value NEWDOC42 H1550669X;
label value NHRWG31 H1550670X;
label value NHRWG42 H1550671X;
label value NHRWG53 H1550672X;
label value NOASPR53 H1550673X;
label value NOFAT53 H1550674X;
label value NOGODR42 H1550675X;
label value NOHINS42 H1550676X;
label value NOINSBEF H1550677X;
label value NOINSTM H1550678X;
label value NOINUNIT H1550679X;
label value NOLIKE42 H1550680X;
label value NOREAS42 H1550681X;
label value NOSMOK42 H1550682X;
label value NUMEMP31 H1550683X;
label value NUMEMP42 H1550684X;
label value NUMEMP53 H1550685X;
label value NWK31 H1550686X;
label value NWK42 H1550687X;
label value NWK53 H1550688X;
label value OBAOPU12 H1550689X;
label value OBASST12 H1550690X;
label value OBCHIR12 H1550691X;
label value OBDRV12 H1550692X;
label value OBNURS12 H1550693X;
label value OBOPTO12 H1550694X;
label value OBOTHV12 H1550695X;
label value OBTHER12 H1550696X;
label value OBTOTV12 H1550697X;
label value OCCCAT31 H1550698X;
label value OCCCAT42 H1550699X;
label value OCCCAT53 H1550700X;
label value OFFER31X H1550701X;
label value OFFER42X H1550702X;
label value OFFER53X H1550703X;
label value OFFHOU42 H1550704X;
label value OFREMP31 H1550705X;
label value OFREMP42 H1550706X;
label value OFREMP53 H1550707X;
label value OHRTAGED H1550708X;
label value OHRTDX H1550709X;
label value ONGONG42 H1550710X;
label value ONJOB42 H1550711X;
label value OPAAP12 H1550712X;
label value OPAAU12 H1550713X;
label value OPADE12 H1550714X;
label value OPAEV12 H1550715X;
label value OPAFE12 H1550716X;
label value OPAJA12 H1550717X;
label value OPAJL12 H1550718X;
label value OPAJU12 H1550719X;
label value OPAMA12 H1550720X;
label value OPAMY12 H1550721X;
label value OPANO12 H1550722X;
label value OPAOC12 H1550723X;
label value OPASE12 H1550724X;
label value OPBAP12 H1550725X;
label value OPBAU12 H1550726X;
label value OPBDE12 H1550727X;
label value OPBEV12 H1550728X;
label value OPBFE12 H1550729X;
label value OPBJA12 H1550730X;
label value OPBJL12 H1550731X;
label value OPBJU12 H1550732X;
label value OPBMA12 H1550733X;
label value OPBMY12 H1550734X;
label value OPBNO12 H1550735X;
label value OPBOC12 H1550736X;
label value OPBSE12 H1550737X;
label value OPDRV12 H1550738X;
label value OPOTHV12 H1550739X;
label value OPTOTV12 H1550740X;
label value OTHDYS31 H1550741X;
label value OTHDYS42 H1550742X;
label value OTHDYS53 H1550743X;
label value OTHIMP12 H1550744X;
label value OTHINS42 H1550745X;
label value OTHNDD31 H1550746X;
label value OTHNDD42 H1550747X;
label value OTHNDD53 H1550748X;
label value OTHRAGED H1550749X;
label value OTHRCP42 H1550750X;
label value OTHREA42 H1550751X;
label value OTHRREMS H1550752X;
label value OTPAAT12 H1550753X;
label value OTPAAT31 H1550754X;
label value OTPAAT42 H1550755X;
label value OTPAAT53 H1550756X;
label value OTPBAT12 H1550757X;
label value OTPBAT31 H1550758X;
label value OTPBAT42 H1550759X;
label value OTPBAT53 H1550760X;
label value OTPUBA12 H1550761X;
label value OTPUBA31 H1550762X;
label value OTPUBA42 H1550763X;
label value OTPUBA53 H1550764X;
label value OTPUBB12 H1550765X;
label value OTPUBB31 H1550766X;
label value OTPUBB42 H1550767X;
label value OTPUBB53 H1550768X;
label value PACISP42 H1550769X;
label value PANEL H1550770X;
label value PAPSMR53 H1550771X;
label value PAYDR31 H1550772X;
label value PAYDR42 H1550773X;
label value PAYDR53 H1550774X;
label value PAYVAC31 H1550775X;
label value PAYVAC42 H1550776X;
label value PAYVAC53 H1550777X;
label value PBINFM42 H1550778X;
label value PBINFT42 H1550779X;
label value PBPWKM42 H1550780X;
label value PBPWKT42 H1550781X;
label value PBSVCM42 H1550782X;
label value PBSVCT42 H1550783X;
label value PCS42 H1550784X;
label value PDKAP12 H1550785X;
label value PDKAU12 H1550786X;
label value PDKDE12 H1550787X;
label value PDKFE12 H1550788X;
label value PDKJA12 H1550789X;
label value PDKJL12 H1550790X;
label value PDKJU12 H1550791X;
label value PDKMA12 H1550792X;
label value PDKMY12 H1550793X;
label value PDKNO12 H1550794X;
label value PDKOC12 H1550795X;
label value PDKSE12 H1550796X;
label value PEGAP12 H1550797X;
label value PEGAU12 H1550798X;
label value PEGDE12 H1550799X;
label value PEGFE12 H1550800X;
label value PEGJA12 H1550801X;
label value PEGJL12 H1550802X;
label value PEGJU12 H1550803X;
label value PEGMA12 H1550804X;
label value PEGMY12 H1550805X;
label value PEGNO12 H1550806X;
label value PEGOC12 H1550807X;
label value PEGSE12 H1550808X;
label value PENIMP12 H1550809X;
label value PERSLA42 H1550810X;
label value PHMONP12 H1550811X;
label value PHMONP31 H1550812X;
label value PHMONP42 H1550813X;
label value PHNREG42 H1550814X;
label value PHQ242 H1550815X;
label value PHYEXE53 H1550816X;
label value PHYSCL42 H1550817X;
label value PLCTYP42 H1550818X;
label value PMDINS12 H1550819X;
label value PMDINS31 H1550820X;
label value PMDLAY42 H1550821X;
label value PMDLPR42 H1550822X;
label value PMDLRS42 H1550823X;
label value PMEDIN31 H1550824X;
label value PMEDIN42 H1550825X;
label value PMEDIN53 H1550826X;
label value PMEDPP31 H1550827X;
label value PMEDPP42 H1550828X;
label value PMEDPP53 H1550829X;
label value PMEDPY31 H1550830X;
label value PMEDPY42 H1550831X;
label value PMEDPY53 H1550832X;
label value PMEDUP31 H1550833X;
label value PMEDUP42 H1550834X;
label value PMEDUP53 H1550835X;
label value PMNCNP12 H1550836X;
label value PMNCNP31 H1550837X;
label value PMNCNP42 H1550838X;
label value PMUNAB42 H1550839X;
label value PMUNPR42 H1550840X;
label value PMUNRS42 H1550841X;
label value PNGAP12 H1550842X;
label value PNGAU12 H1550843X;
label value PNGDE12 H1550844X;
label value PNGFE12 H1550845X;
label value PNGJA12 H1550846X;
label value PNGJL12 H1550847X;
label value PNGJU12 H1550848X;
label value PNGMA12 H1550849X;
label value PNGMY12 H1550850X;
label value PNGNO12 H1550851X;
label value PNGOC12 H1550852X;
label value PNGSE12 H1550853X;
label value POGAP12 H1550854X;
label value POGAU12 H1550855X;
label value POGDE12 H1550856X;
label value POGFE12 H1550857X;
label value POGJA12 H1550858X;
label value POGJL12 H1550859X;
label value POGJU12 H1550860X;
label value POGMA12 H1550861X;
label value POGMY12 H1550862X;
label value POGNO12 H1550863X;
label value POGOC12 H1550864X;
label value POGSE12 H1550865X;
label value POUAP12 H1550866X;
label value POUAU12 H1550867X;
label value POUDE12 H1550868X;
label value POUFE12 H1550869X;
label value POUJA12 H1550870X;
label value POUJL12 H1550871X;
label value POUJU12 H1550872X;
label value POUMA12 H1550873X;
label value POUMY12 H1550874X;
label value POUNO12 H1550875X;
label value POUOC12 H1550876X;
label value POUSE12 H1550877X;
label value POVCAT12 H1550878X;
label value PPRWKM42 H1550879X;
label value PPRWKT42 H1550880X;
label value PRDRNP12 H1550881X;
label value PRDRNP31 H1550882X;
label value PRDRNP42 H1550883X;
label value PREGNT31 H1550884X;
label value PREGNT42 H1550885X;
label value PREGNT53 H1550886X;
label value PREVCOVR H1550887X;
label value PREVEN42 H1550888X;
label value PRIAP12 H1550889X;
label value PRIAU12 H1550890X;
label value PRIDE12 H1550891X;
label value PRIDK12 H1550892X;
label value PRIDK31 H1550893X;
label value PRIDK42 H1550894X;
label value PRIDK53 H1550895X;
label value PRIEU12 H1550896X;
label value PRIEU31 H1550897X;
label value PRIEU42 H1550898X;
label value PRIEU53 H1550899X;
label value PRIFE12 H1550900X;
label value PRIJA12 H1550901X;
label value PRIJL12 H1550902X;
label value PRIJU12 H1550903X;
label value PRIMA12 H1550904X;
label value PRIMY12 H1550905X;
label value PRING12 H1550906X;
label value PRING31 H1550907X;
label value PRING42 H1550908X;
label value PRING53 H1550909X;
label value PRINO12 H1550910X;
label value PRIOC12 H1550911X;
label value PRIOG12 H1550912X;
label value PRIOG31 H1550913X;
label value PRIOG42 H1550914X;
label value PRIOG53 H1550915X;
label value PRIS12 H1550916X;
label value PRIS31 H1550917X;
label value PRIS42 H1550918X;
label value PRIS53 H1550919X;
label value PRISE12 H1550920X;
label value PRIV12 H1550921X;
label value PRIV31 H1550922X;
label value PRIV42 H1550923X;
label value PRIV53 H1550924X;
label value PRIVAT12 H1550925X;
label value PRIVAT31 H1550926X;
label value PRIVAT42 H1550927X;
label value PRIVAT53 H1550928X;
label value PROUT12 H1550929X;
label value PROUT31 H1550930X;
label value PROUT42 H1550931X;
label value PROUT53 H1550932X;
label value PROVTY42 H1550933X;
label value PROXY12 H1550934X;
label value PROXY31 H1550935X;
label value PROXY42 H1550936X;
label value PROXY53 H1550937X;
label value PRSAP12 H1550938X;
label value PRSAU12 H1550939X;
label value PRSDE12 H1550940X;
label value PRSFE12 H1550941X;
label value PRSJA12 H1550942X;
label value PRSJL12 H1550943X;
label value PRSJU12 H1550944X;
label value PRSMA12 H1550945X;
label value PRSMY12 H1550946X;
label value PRSNO12 H1550947X;
label value PRSOC12 H1550948X;
label value PRSSE12 H1550949X;
label value PRSTAGED H1550950X;
label value PRSTREMS H1550951X;
label value PRVDRL12 H1550952X;
label value PRVDRL31 H1550953X;
label value PRVDRL42 H1550954X;
label value PRVEV12 H1550955X;
label value PRVHMO12 H1550956X;
label value PRVHMO31 H1550957X;
label value PRVHMO42 H1550958X;
label value PRVMNC12 H1550959X;
label value PRVMNC31 H1550960X;
label value PRVMNC42 H1550961X;
label value PSA53 H1550962X;
label value PSTATS31 H1550963X;
label value PSTATS42 H1550964X;
label value PSTATS53 H1550965X;
label value PUB12X H1550966X;
label value PUB31X H1550967X;
label value PUB42X H1550968X;
label value PUB53X H1550969X;
label value PUBAP12X H1550970X;
label value PUBAT12X H1550971X;
label value PUBAT31X H1550972X;
label value PUBAT42X H1550973X;
label value PUBAT53X H1550974X;
label value PUBAU12X H1550975X;
label value PUBDE12X H1550976X;
label value PUBFE12X H1550977X;
label value PUBIMP12 H1550978X;
label value PUBJA12X H1550979X;
label value PUBJL12X H1550980X;
label value PUBJU12X H1550981X;
label value PUBMA12X H1550982X;
label value PUBMY12X H1550983X;
label value PUBNO12X H1550984X;
label value PUBOC12X H1550985X;
label value PUBSE12X H1550986X;
label value RACEAX H1550987X;
label value RACEBX H1550988X;
label value RACETHX H1550989X;
label value RACEV1X H1550990X;
label value RACEVER H1550991X;
label value RACEWX H1550992X;
label value RCHDIF31 H1550993X;
label value RCHDIF53 H1550994X;
label value READNW42 H1550995X;
label value RECPEP42 H1550996X;
label value REFFRL42 H1550997X;
label value REFIMP12 H1550998X;
label value REGION12 H1550999X;
label value REGION31 H1551000X;
label value REGION42 H1551001X;
label value REGION53 H1551002X;
label value RESP12 H1551003X;
label value RESP31 H1551004X;
label value RESP42 H1551005X;
label value RESP53 H1551006X;
label value RESPCT42 H1551007X;
label value RETPLN31 H1551008X;
label value RETPLN42 H1551009X;
label value RETPLN53 H1551010X;
label value RFREL12X H1551011X;
label value RFREL31X H1551012X;
label value RFREL42X H1551013X;
label value RFREL53X H1551014X;
label value RNDFLG31 H1551015X;
label value RTHLTH31 H1551016X;
label value RTHLTH42 H1551017X;
label value RTHLTH53 H1551018X;
label value RTPLNM42 H1551019X;
label value RTPLNT42 H1551020X;
label value RUCLAS12 H1551021X;
label value RUCLAS31 H1551022X;
label value RUCLAS42 H1551023X;
label value RUCLAS53 H1551024X;
label value RUSIZE12 H1551025X;
label value RUSIZE31 H1551026X;
label value RUSIZE42 H1551027X;
label value RUSIZE53 H1551028X;
label value SAFEST42 H1551029X;
label value SALIMP12 H1551030X;
label value SAQELIG H1551031X;
label value SCHLBH42 H1551032X;
label value SCHLIM31 H1551033X;
label value SCHLIM53 H1551034X;
label value SCHPRO42 H1551035X;
label value SCLNBD31 H1551036X;
label value SCLNBD42 H1551037X;
label value SCLNBD53 H1551038X;
label value SEATBE53 H1551039X;
label value SEEDIF42 H1551040X;
label value SELDSI42 H1551041X;
label value SELFCM31 H1551042X;
label value SELFCM42 H1551043X;
label value SELFCM53 H1551044X;
label value SEX H1551045X;
label value SFFLAG42 H1551046X;
label value SGMTRE53 H1551047X;
label value SGMTST53 H1551048X;
label value SIBPRO42 H1551049X;
label value SICEAS42 H1551050X;
label value SICPAY31 H1551051X;
label value SICPAY42 H1551052X;
label value SICPAY53 H1551053X;
label value SKDKAGED H1551054X;
label value SKDKREMS H1551055X;
label value SKNMAGED H1551056X;
label value SKNMREMS H1551057X;
label value SOCLIM31 H1551058X;
label value SOCLIM53 H1551059X;
label value SPOUID12 H1551060X;
label value SPOUID31 H1551061X;
label value SPOUID42 H1551062X;
label value SPOUID53 H1551063X;
label value SPOUIN12 H1551064X;
label value SPOUIN31 H1551065X;
label value SPOUIN42 H1551066X;
label value SPOUIN53 H1551067X;
label value SPRPRO42 H1551068X;
label value SSCIMP12 H1551069X;
label value SSIDIS12 H1551070X;
label value SSIIMP12 H1551071X;
label value SSNLJB31 H1551072X;
label value SSNLJB42 H1551073X;
label value SSNLJB53 H1551074X;
label value STAAP12 H1551075X;
label value STAAU12 H1551076X;
label value STADE12 H1551077X;
label value STAFE12 H1551078X;
label value STAJA12 H1551079X;
label value STAJL12 H1551080X;
label value STAJU12 H1551081X;
label value STAMA12 H1551082X;
label value STAMY12 H1551083X;
label value STANO12 H1551084X;
label value STAOC12 H1551085X;
label value STAPR12 H1551086X;
label value STAPR31 H1551087X;
label value STAPR42 H1551088X;
label value STAPR53 H1551089X;
label value STASE12 H1551090X;
label value STJBDD31 H1551091X;
label value STJBDD42 H1551092X;
label value STJBDD53 H1551093X;
label value STJBMM31 H1551094X;
label value STJBMM42 H1551095X;
label value STJBMM53 H1551096X;
label value STJBYY31 H1551097X;
label value STJBYY42 H1551098X;
label value STJBYY53 H1551099X;
label value STNDIF31 H1551100X;
label value STNDIF53 H1551101X;
label value STOMCH53 H1551102X;
label value STPDIF31 H1551103X;
label value STPDIF53 H1551104X;
label value STPRAT12 H1551105X;
label value STPRAT31 H1551106X;
label value STPRAT42 H1551107X;
label value STPRAT53 H1551108X;
label value STRKAGED H1551109X;
label value STRKDX H1551110X;
label value TAXFRM12 H1551111X;
label value TEMPJB31 H1551112X;
label value TEMPJB42 H1551113X;
label value TEMPJB53 H1551114X;
label value THRTAGED H1551115X;
label value THRTREMS H1551116X;
label value THYRAGED H1551117X;
label value THYRREMS H1551118X;
label value TIMALN42 H1551119X;
label value TMTKUS42 H1551120X;
label value TOTDED12 H1551121X;
label value TRANS42 H1551122X;
label value TRBLE42 H1551123X;
label value TREATM42 H1551124X;
label value TRIAP12X H1551125X;
label value TRIAT12X H1551126X;
label value TRIAT31X H1551127X;
label value TRIAT42X H1551128X;
label value TRIAT53X H1551129X;
label value TRIAU12X H1551130X;
label value TRICH12X H1551131X;
label value TRICH31X H1551132X;
label value TRICH42X H1551133X;
label value TRICR12X H1551134X;
label value TRICR31X H1551135X;
label value TRICR42X H1551136X;
label value TRICR53X H1551137X;
label value TRIDE12X H1551138X;
label value TRIEV12 H1551139X;
label value TRIEX12X H1551140X;
label value TRIEX31X H1551141X;
label value TRIEX42X H1551142X;
label value TRIFE12X H1551143X;
label value TRIJA12X H1551144X;
label value TRIJL12X H1551145X;
label value TRIJU12X H1551146X;
label value TRILI12X H1551147X;
label value TRILI31X H1551148X;
label value TRILI42X H1551149X;
label value TRIMA12X H1551150X;
label value TRIMY12X H1551151X;
label value TRINO12X H1551152X;
label value TRIOC12X H1551153X;
label value TRIPR12X H1551154X;
label value TRIPR31X H1551155X;
label value TRIPR42X H1551156X;
label value TRISE12X H1551157X;
label value TRIST12X H1551158X;
label value TRIST31X H1551159X;
label value TRIST42X H1551160X;
label value TRTIMP12 H1551161X;
label value TYPEPE42 H1551162X;
label value UNABLE31 H1551163X;
label value UNABLE53 H1551164X;
label value UNEIMP12 H1551165X;
label value UNHAP42 H1551166X;
label value UNINS12 H1551167X;
label value UNION31 H1551168X;
label value UNION42 H1551169X;
label value UNION53 H1551170X;
label value USBORN42 H1551171X;
label value USCNOT42 H1551172X;
label value USLIVE42 H1551173X;
label value VETIMP12 H1551174X;
label value VISION42 H1551175X;
label value VISWCP12 H1551176X;
label value WAGIMP12 H1551177X;
label value WASAFDC H1551178X;
label value WASCHAMP H1551179X;
label value WASESTB H1551180X;
label value WASMCAID H1551181X;
label value WASMCARE H1551182X;
label value WASOTGOV H1551183X;
label value WASOTHER H1551184X;
label value WASPRIV H1551185X;
label value WASSSI H1551186X;
label value WASSTAT1 H1551187X;
label value WASSTAT2 H1551188X;
label value WASSTAT3 H1551189X;
label value WASSTAT4 H1551190X;
label value WASVA H1551191X;
label value WCPIMP12 H1551192X;
label value WHITPR42 H1551193X;
label value WHNBPR42 H1551194X;
label value WHNBST42 H1551195X;
label value WHNDEN42 H1551196X;
label value WHNEAT42 H1551197X;
label value WHNHEL42 H1551198X;
label value WHNHGT42 H1551199X;
label value WHNLAP42 H1551200X;
label value WHNPHY42 H1551201X;
label value WHNSAF42 H1551202X;
label value WHNSMK42 H1551203X;
label value WHNWGT42 H1551204X;
label value WILFIL12 H1551205X;
label value WKINBD31 H1551206X;
label value WKINBD42 H1551207X;
label value WKINBD53 H1551208X;
label value WLK3MO31 H1551209X;
label value WLK3MO53 H1551210X;
label value WLKDIF31 H1551211X;
label value WLKDIF53 H1551212X;
label value WLKLIM31 H1551213X;
label value WLKLIM53 H1551214X;
label value WRGLAS42 H1551215X;
label value WRHLTH42 H1551216X;
label value WRKLIM31 H1551217X;
label value WRKLIM53 H1551218X;
label value YCHJ3142 H1551219X;
label value YCHJ4253 H1551220X;
label value YNOINS31 H1551221X;
label value YNOINS42 H1551222X;
label value YNOINS53 H1551223X;
label value YNOUSC42 H1551224X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H155.LOG and a data file named H155.DTA.  If these files (H155.DTA and H155.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

